﻿'use strict';

const	systemWindows	= window.navigator.platform.startsWith('Win'),
	CRLFalboLF	= systemWindows ? '\r\n' : '\n';
let	fontHeight	= 12,
	fontWidth50	= 350,
	pfontHeight	= 8,
	scrollbarHeight	= 20,
	scrollbarWidth	= 20;

const	opisRozkazu	= [	// Maksymalna szerokość opisu = 40 znaków
//T=0
'0;  ║0Z0',		'[α] = 0;  ║0Z0',		'Bε = 0;  ║0Z0',		'R = 0;  ║0Z0',			'M=0,  M,  AM = A*M;  Ω║0Z00',		'M=0,  M,  A = A/M;  Ω║0Z0●',		'-',				'-',
'[α];  ║uz0',		      '[α];  ║uz0  HAK',	'Bε = [α];  ║uz0',		'R = [α];  ║uz0',		'M=[α],  M,  AM = A*M;  Ω║uz0n',	'M=[α],  M,  A = A/M;  Ω║uz0/',		'LL:  A = A <<< δ;  ║uz0',	'-',
'Bε;  ║uz0',		'[α] = Bε;  ║uz0',		'Bε = Bε;  ║uz0',		'R = Bε;  ║uz0',		'M=Bε,  M,  AM = A*M;  Ω║uz0n',		'M=Bε,  M,  A = A/M;  Ω║uz0/',		'We0:  A₃₄₋₃₈ = PTR0;  ║uz.',	'-',
'β;  ║0z0',		'[α] = β;  ║0z0',		'Bε = β;  ║0z0',		'R = β;  ║0z0',			'M=β,  M,  AM = A*M;  Ω║uz00',		'M=β,  M,  A = A/M;  Ω║uz0/',		'-',				'-',
'A = 0;  ║0Z0',		'[α] = A = 0;  ║0Z0',		'Bε = A = 0;  ║0Z0',		'R = A = 0;  ║0Z0',		'M=0,  A=M,  AM = A*M;  Ω║0Z00',	'M=0,  A=M,  A = A/M;  Ω║0Z0●',		'SkZ:  if (0Zv) goto α;',	'-',
'A = [α];  ║uz0',	      'A = [α];  ║uz0  HAK',	'Bε = A = [α];  ║uz0',		'R = A = [α];  ║uz0',		'M=[α],  A=M,  AM = A*M;  Ω║uz0n',	'M=[α],  A=M,  A = A/M;  Ω║uz0/',	'-',				'-',
'A = Bε;  ║uz0',	'[α] = A = Bε;  ║uz0',		'Bε = A = Bε;  ║uz0',		'R = A = Bε;  ║uz0',		'M=Bε,  A=M,  AM = A*M;  Ω║uz0n',	'M=Bε,  A=M,  A = A/M;  Ω║uz0/',	"XWe0:  A₃₁₋₃₈ = PTR0';  ║uz.",	'-',
'A = β;  ║0z0',		'[α] = A = β;  ║0z0',		'Bε = A = β;  ║0z0',		'R = A = β;  ║0z0',		'M=β,  A=M,  AM = A*M;  Ω║0z00',	'M=β,  A=M,  A = A/M;  Ω║0z0N',		'-',				'-',
//T=1
'-0;  ║0Z0',		'[α] = -0;  ║0Z0',		'Bε = -0;  ║0Z0',		'R = -0;  ║0Z0',		'M=0,  -M,  AM = A*M;  Ω║0Z00',		'M=0,  -M,  A = A/M;  Ω║0Z0●',		'-',				'AC = [α], BON;  ║uz.0',
'-[α];  ║uzv',		      '-[α];  ║uzv  HAK',	'Bε = -[α];  ║uzv',		'R = -[α];  ║uzv',		'M=[α],  -M,  AM = A*M;  Ω║uzvn',	'M=[α],  -M,  A = A/M;  Ω║uzv/',	'LP:  A = A >>> δ;  Ω║uz0',	'AC = [α], BO;  ║uz.0',
'-Bε;  ║uzv',		'[α] = -Bε;  ║uzv',		'Bε = -Bε;  ║uzv',		'R = -Bε;  ║uzv',		'M=Bε,  -M,  AM = A*M;  Ω║uzvn',	'M=Bε,  -M,  A = A/M;  Ω║uzv/',		'We1:  A₃₄₋₃₈ = TTY;  ║uz.',	'AC = [α], BN;  ║uz.0',
'-β;  ║uz0',		'[α] = -β;  ║uz0',		'Bε = -β;  ║uz0',		'R = -β;  ║uz0',		'M=β,  -M,  AM = A*M;  Ω║uz00',		'M=β,  -M,  A = A/M;  Ω║uz0/',		'BF61:  Ferryt61 <-- β(1+Bε);',	'AC = [α];  ║uz.0',
'A = -0;  ║0Z0',	'[α] = A = -0;  ║0Z0',		'Bε = A = -0;  ║0Z0',		'R = A = -0;  ║0Z0',		'M=0,  A=-M,  AM = A*M;  Ω║0Z00',	'M=0,  A=-M,  A = A/M;  Ω║0Z0●',	'SkU:  if (U0v) goto α;',	'AC = Bε, BON;  ║uz.0',
'A = -[α];  ║uzv',	      'A = -[α];  ║uzv  HAK',	'Bε = A = -[α];  ║uzv',		'R = A = -[α];  ║uzv',		'M=[α],  A=-M,  AM = A*M;  Ω║uzvn',	'M=[α],  A=-M,  A = A/M;  Ω║uzv/',	'-',				'AC = Bε, BO;  ║uz.0',
'A = -Bε;  ║uzv',	'[α] = A = -Bε;  ║uzv',		'Bε = A = -Bε;  ║uzv',		'R = A = -Bε;  ║uzv',		'M=Bε,  A=-M,  AM = A*M;  Ω║uzvn',	'M=Bε,  A=-M,  A = A/M;  Ω║uzv/',	'-',				'AC = Bε, BN;  ║uz.0',
'A = -β;  ║uz0',	'[α] = A = -β;  ║uz0',		'Bε = A = -β;  ║uz0',		'R = A = -β;  ║uz0',		'M=β,  A=-M,  AM = A*M;  Ω║uz00',	'M=β,  A=-M,  A = A/M;  Ω║uz0/',	'-',				'AC = Bε;  ║uz.0',
//T=2
'|0|;  ║0Z0',		'[α] = |0|;  ║0Z0',		'Bε = |0|;  ║0Z0',		'R = |0|;  ║0Z0',		'M=0,  |M|,  AM = A*M;  Ω║0Z00',	'M=0,  |M|,  A = A/M;  Ω║0Z0●',		'-',				'[α] = AC, BON;  ║uz.0',
'|[α]|;  ║0zv',		      '|[α]|;  ║0zv  HAK',	'Bε = |[α]|;  ║0zv',		'R = |[α]|;  ║0zv',		'M=[α],  |M|,  AM = A*M;  Ω║uzvn',	'M=[α],  |M|,  A = A/M;  Ω║uzv/',	'AL:  A = A << δ;  ║uzv',	'[α] = AC, BON;  ║uz.0  HAK',
'|Bε|;  ║0zv',		'[α] = |Bε|;  ║0zv',		'Bε = |Bε|;  ║0zv',		'R = |Bε|;  ║0zv',		'M=Bε,  |M|,  AM = A*M;  Ω║uzvn',	'M=Bε,  |M|,  A = A/M;  Ω║uzv/',	'We2:  A₃₄₋₃₈ = PTR2;  ║uz.',	'[α] = AC, BON;  ║uz.0  HAK',
'|α|;  ║0z0',		'[α] = |α|;  ║0z0',		'Bε = |α|;  ║0z0',		'R = |α|;  ║0z0',		'M=β,  |M|,  AM = A*M;  Ω║uz00',	'M=β,  |M|,  A = A/M;  Ω║uz0/',		'BF62:  Ferryt62 <-- β(1+Bε);',	'[α] = AC, BON;  ║uz.0  HAK',
'A = |0|;  ║0Z0',	'[α] = A = |0|;  ║0Z0',		'Bε = A = |0|;  ║0Z0',		'R = A = |0|;  ║0Z0',		'M=0,  A=|M|,  AM = A*M;  Ω║0Z00',	'M=0,  A=|M|,  A = A/M;  Ω║0Z0●',	'SkD:  if (00v) goto α;',	'Bε = AC, BON;  ║uz.0',
'A = |[α]|;  ║0zv',	      'A = |[α]|;  ║0zv  HAK',	'Bε = A = |[α]|;  ║0zv',	'R = A = |[α]|;  ║0zv',		'M=[α],  A=|M|,  AM = A*M;  Ω║uzvn',	'M=[α],  A=|M|,  A = A/M;  Ω║uzv/',	'-',				'Bε = AC, BON;  ║uz.0  HAK',
'A = |Bε|;  ║0zv',	'[α] = A = |Bε|;  ║0zv',	'Bε = A = |Bε|;  ║0zv',		'R = A = |Bε|;  ║0zv',		'M=Bε,  A=|M|,  AM = A*M;  Ω║uzvn',	'M=Bε,  A=|M|,  A = A/M;  Ω║uzv/',	"XWe2:  A₃₁₋₃₈ = PTR2';  ║uz.",	'Bε = AC, BON;  ║uz.0  HAK',
'A = |α|;  ║0z0',	'[α] = A = |α|;  ║0z0',		'Bε = A = |α|;  ║0z0',		'R = A = |α|;  ║0z0',		'M=β,  A=|M|,  AM = A*M;  Ω║uz00',	'M=β,  A=|M|,  A = A/M;  Ω║uz0N',	'-',				'Bε = AC, BON;  ║uz.0  HAK',
//T=3
'A - 0;  ║uz0',		'[α] = A - 0;  ║uz0',		'Bε = A - 0;  ║uz0',		'R = A - 0;  ║uz0',		'M=0,  A-M,  AM = A*M;  Ω║0Z00',	'M=0,  A-M,  A = A/M;  Ω║uz0●',		'-',				'AC = AC + [α], BON;  ║uz.*',
'A - [α];  ║uzv',	      'A - [α];  ║uzv  HAK',	'Bε = A - [α];  ║uzv',		'R = A - [α];  ║uzv',		'M=[α],  A-M,  AM = A*M;  Ω║uzvn',	'M=[α],  A-M,  A = A/M;  Ω║uzv/',	'AP:  A = A >> δ;  Ω║uz0',	'AC = AC + [α], BO;  ║uz.*',
'A - Bε;  ║uzv',	'[α] = A - Bε;  ║uzv',		'Bε = A - Bε;  ║uzv',		'R = A - Bε;  ║uzv',		'M=Bε,  A-M,  AM = A*M;  Ω║uzvn',	'M=Bε,  A-M,  A = A/M;  Ω║uzv/',	'CzK:  A = przyciskiA;  ║uz.',	'AC = AC + [α], BN;  ║uz.*',
'A - β;  ║uzv',		'[α] = A - β;  ║uzv',		'Bε = A - β;  ║uzv',		'R = A - β;  ║uzv',		'M=β,  A-M,  AM = A*M;  Ω║uzv0',	'M=β,  A-M,  A = A/M;  Ω║uzv/',		'FB61:  Ferryt61 --> β(1+Bε);',	'AC = AC + [α];  ║uz.*',
'A = A - 0;  ║uz0',	'[α] = A = A - 0;  ║uz0',	'Bε = A = A - 0;  ║uz0',	'R = A = A - 0;  ║uz0',		'M=0,  A=A-M,  AM = A*M;  Ω║0Z00',	'M=0,  A=A-M,  A = A/M;  Ω║uz0●',	'SkV:  if (uzV) goto α;',	'AC = AC + Bε, BON;  ║uz.*',
'A = A - [α];  ║uzv',	      'A = A - [α];  ║uzv  HAK','Bε = A = A - [α];  ║uzv',	'R = A = A - [α];  ║uzv',	'M=[α],  A=A-M,  AM = A*M;  Ω║uzvn',	'M=[α],  A=A-M,  A = A/M;  Ω║uzv/',	'-',				'AC = AC + Bε, BO;  ║uz.*',
'A = A - Bε;  ║uzv',	'[α] = A = A - Bε;  ║uzv',	'Bε = A = A - Bε;  ║uzv',	'R = A = A - Bε;  ║uzv',	'M=Bε,  A=A-M,  AM = A*M;  Ω║uzvn',	'M=Bε,  A=A-M,  A = A/M;  Ω║uzv/',	'-',				'AC = AC + Bε, BN;  ║uz.*',
'A = A - β;  ║uzv',	'[α] = A = A - β;  ║uzv',	'Bε = A = A - β;  ║uzv',	'R = A = A - β;  ║uzv',		'M=β,  A=A-M,  AM = A*M;  Ω║uzv0',	'M=β,  A=A-M,  A = A/M;  Ω║uzv/',	'-',				'AC = AC + Bε;  ║uz.*',
//T=4
'A + 0;  ║uz0',		'[α] = A + 0;  ║uz0',		'Bε = A + 0;  ║uz0',		'R = A + 0;  ║uz0',		'M=0,  A+M,  AM = A*M;  Ω║0Z00',	'M=0,  A+M,  A = A/M;  Ω║uz0●',		'-',				'AC = AC - [α], BON;  ║uz.*',
'A + [α];  ║uzv',	      'A + [α];  ║uzv  HAK',	'Bε = A + [α];  ║uzv',		'R = A + [α];  ║uzv',		'M=[α],  A+M,  AM = A*M;  Ω║uzvn',	'M=[α],  A+M,  A = A/M;  Ω║uzv/',	'CP:  A = A >>< δ;  Ω║uz0',	'AC = AC - [α], BO;  ║uz.*',
'A + Bε;  ║uzv',	'[α] = A + Bε;  ║uzv',		'Bε = A + Bε;  ║uzv',		'R = A + Bε;  ║uzv',		'M=Bε,  A+M,  AM = A*M;  Ω║uzvn',	'M=Bε,  A+M,  A = A/M;  Ω║uzv/',	'Okr:  A = A + Ω;  ║uzv',	'AC = AC - [α], BN;  ║uz.*',
'A + β;  ║uzv',		'[α] = A + β;  ║uzv',		'Bε = A + β;  ║uzv',		'R = A + β;  ║uzv',		'M=β,  A+M,  AM = A*M;  Ω║uzv0',	'M=β,  A+M,  A = A/M;  Ω║uzv/',		'FB62:  Ferryt62 --> β(1+Bε);',	'AC = AC - [α];  ║uz.*',
'A = A + 0;  ║uz0',	'[α] = A = A + 0;  ║uz0',	'Bε = A = A + 0;  ║uz0',	'R = A = A + 0;  ║uz0',		'M=0,  A=A+M,  AM = A*M;  Ω║0Z00',	'M=0,  A=A+M,  A = A/M;  Ω║uz0●',	'SkBG:  if (BGWeε) goto α;',	'AC = AC - Bε, BON;  ║uz.*',
'A = A + [α];  ║uzv',	      'A = A + [α];  ║uzv  HAK','Bε = A = A + [α];  ║uzv',	'R = A = A + [α];  ║uzv',	'M=[α],  A=A+M,  AM = A*M;  Ω║uzvn',	'M=[α],  A=A+M,  A = A/M;  Ω║uzv/',	'-',				'AC = AC - Bε, BO;  ║uz.*',
'A = A + Bε;  ║uzv',	'[α] = A = A + Bε;  ║uzv',	'Bε = A = A + Bε;  ║uzv',	'R = A = A + Bε;  ║uzv',	'M=Bε,  A=A+M,  AM = A*M;  Ω║uzvn',	'M=Bε,  A=A+M,  A = A/M;  Ω║uzv/',	'-',				'AC = AC - Bε, BN;  ║uz.*',
'A = A + β;  ║uzv',	'[α] = A = A + β;  ║uzv',	'Bε = A = A + β;  ║uzv',	'R = A = A + β;  ║uzv',		'M=β,  A=A+M,  AM = A*M;  Ω║uzv0',	'M=β,  A=A+M,  A = A/M;  Ω║uzv/',	'-',				'AC = AC - Bε;  ║uz.*',
//T=5
'0 - A;  ║uzv',		'[α] = 0 - A;  ║uzv',		'Bε = 0 - A;  ║uzv',		'R = 0 - A;  ║uzv',		'M=0,  M-A,  AM = A*M;  Ω║uzv0',	'M=0,  M-A,  A = A/M;  Ω║uzv●',		'-',				'AC = [α] - AC, BON;  ║uz.*',
'[α] - A;  ║uzv',	      '[α] - A;  ║uzv  HAK',	'Bε = [α] - A;  ║uzv',		'R = [α] - A;  ║uzv',		'M=[α],  M-A,  AM = A*M;  Ω║uzvn',	'M=[α],  M-A,  A = A/M;  Ω║uzv/',	'ALD:  AM = AM << γ;  Ω║uzv',	'AC = [α] - AC, BO;  ║uz.*',
'Bε - A;  ║uzv',	'[α] = Bε - A;  ║uzv',		'Bε = Bε - A;  ║uzv',		'R = Bε - A;  ║uzv',		'M=Bε,  M-A,  AM = A*M;  Ω║uzvn',	'M=Bε,  M-A,  A = A/M;  Ω║uzv/',	'Wy5:  PTP5 = A₀₋₄;  ║uz.',	'AC = [α] - AC, BN;  ║uz.*',
'β - A;  ║uzv',		'[α] = β - A;  ║uzv',		'Bε = β - A;  ║uzv',		'R = β - A;  ║uzv',		'M=β,  M-A,  AM = A*M;  Ω║uzv0',	'M=β,  M-A,  A = A/M;  Ω║uzv/',		'-',				'AC = [α] - AC;  ║uz.*',
'A = 0 - A;  ║uzv',	'[α] = A = 0 - A;  ║uzv',	'Bε = A = 0 - A;  ║uzv',	'R = A = 0 - A;  ║uzv',		'M=0,  A=M-A,  AM = A*M;  Ω║uzv0',	'M=0,  A=M-A,  A = A/M;  Ω║uzv●',	'SkLC:  if (Bε--) goto α;',	'AC = Bε - AC, BON;  ║uz.*',
'A = [α] - A;  ║uzv',	      'A = [α] - A;  ║uzv  HAK','Bε = A = [α] - A;  ║uzv',	'R = A = [α] - A;  ║uzv',	'M=[α],  A=M-A,  AM = A*M;  Ω║uzvn',	'M=[α],  A=M-A,  A = A/M;  Ω║uzv/',	'-',				'AC = Bε - AC, BO;  ║uz.*',
'A = Bε - A;  ║uzv',	'[α] = A = Bε - A;  ║uzv',	'Bε = A = Bε - A;  ║uzv',	'R = A = Bε - A;  ║uzv',	'M=Bε,  A=M-A,  AM = A*M;  Ω║uzvn',	'M=Bε,  A=M-A,  A = A/M;  Ω║uzv/',	"XWy5:  PTP5' = A₀₋₇;  ║uz.",	'AC = Bε - AC, BN;  ║uz.*',
'A = β - A;  ║uzv',	'[α] = A = β - A;  ║uzv',	'Bε = A = β - A;  ║uzv',	'R = A = β - A;  ║uzv',		'M=β,  A=M-A,  AM = A*M;  Ω║uzv0',	'M=β,  A=M-A,  A = A/M;  Ω║uzv/',	'-',				'AC = Bε - AC;  ║uz.*',
//T=6
'A & 0;  ║0Z0',		'[α] = A & 0;  ║0Z0',		'Bε = A & 0;  ║0Z0',		'R = A & 0;  ║0Z0',		'M=0,  A&M,  AM = A*M;  Ω║0Z00',	'M=0,  A&M,  A = A/M;  Ω║0Z0●',		'-',				'AC = AC * [α], BON;  M=#║uz.*',
'A & [α];  ║uz0',	      'A & [α];  ║uz0  HAK',	'Bε = A & [α];  ║uz0',		'R = A & [α];  ║uz0',		'M=[α],  A&M,  AM = A*M;  Ω║uz0n',	'M=[α],  A&M,  A = A/M;  Ω║uz0/',	'APD:  AM = AM >> γ;  Ω║uz0',	'AC = AC * [α], BO;  M=#║uz.*',
'A & Bε;  ║uz0',	'[α] = A & Bε;  ║uz0',		'Bε = A & Bε;  ║uz0',		'R = A & Bε;  ║uz0',		'M=Bε,  A&M,  AM = A*M;  Ω║uz0n',	'M=Bε,  A&M,  A = A/M;  Ω║uz0/',	'Wy6:  TTY = A₀₋₄;  ║uz.',	'AC = AC * [α], BN;  M=#║uz.*',
'A & β;  ║uz0',		'[α] = A & β;  ║uz0',		'Bε = A & β;  ║uz0',		'R = A & β;  ║uz0',		'M=β,  A&M,  AM = A*M;  Ω║uz00',	'M=β,  A&M,  A = A/M;  Ω║uz0/',		'-',				'AC = AC * [α];  M=#║uz.*',
'A = A & 0;  ║0Z0',	'[α] = A = A & 0;  ║0Z0',	'Bε = A = A & 0;  ║0Z0',	'R = A = A & 0;  ║0Z0',		'M=0,  A=A&M,  AM = A*M;  Ω║0Z00',	'M=0,  A=A&M,  A = A/M;  Ω║0Z0●',	'SkLC:  if (Bε++) goto α;',	'AC = AC * Bε, BON;  M=#║uz.*',
'A = A & [α];  ║uz0',	      'A = A & [α];  ║uz0  HAK','Bε = A = A & [α];  ║uz0',	'R = A = A & [α];  ║uz0',	'M=[α],  A=A&M,  AM = A*M;  Ω║uz0n',	'M=[α],  A=A&M,  A = A/M;  Ω║uz0/',	'-',				'AC = AC * Bε, BO;  M=#║uz.*',
'A = A & Bε;  ║uz0',	'[α] = A = A & Bε;  ║uz0',	'Bε = A = A & Bε;  ║uz0',	'R = A = A & Bε;  ║uz0',	'M=Bε,  A=A&M,  AM = A*M;  Ω║uz0n',	'M=Bε,  A=A&M,  A = A/M;  Ω║uz0/',	'-',				'AC = AC * Bε, BN;  M=#║uz.*',
'A = A & β;  ║uz0',	'[α] = A = A & β;  ║uz0',	'Bε = A = A & β;  ║uz0',	'R = A = A & β;  ║uz0',		'M=β,  A=A&M,  AM = A*M;  Ω║uz00',	'M=β,  A=A&M,  A = A/M;  Ω║uz0/',	'-',				'AC = AC * Bε;  M=#║uz.*',
//T=7
'A ^ 0;  ║uz0',		'[α] = A ^ 0;  ║uz0',		'Bε = A ^ 0;  ║uz0',		'R = A ^ 0;  ║uz0',		'M=0,  A^M,  AM = A*M;  Ω║0Z00',	'M=0,  A^M,  A = A/M;  Ω║uz0●',		'-',				'AC = AC / [α], BON;  M=#║uz/*',
'A ^ [α];  ║uz0',	      'A ^ [α];  ║uz0  HAK',	'Bε = A ^ [α];  ║uz0',		'R = A ^ [α];  ║uz0',		'M=[α],  A^M,  AM = A*M;  Ω║uz0n',	'M=[α],  A^M,  A = A/M;  Ω║uz0/',	'DzD:  A = A // M, γ;  Ω║uzv/',	'AC = AC / [α], BO;  M=#║uz/*',
'A ^ Bε;  ║uz0',	'[α] = A ^ Bε;  ║uz0',		'Bε = A ^ Bε;  ║uz0',		'R = A ^ Bε;  ║uz0',		'M=Bε,  A^M,  AM = A*M;  Ω║uz0n',	'M=Bε,  A^M,  A = A/M;  Ω║uz0/',	'Stop α;',			'AC = AC / [α], BN;  M=#║uz/*',
'A ^ β;  ║uz0',		'[α] = A ^ β;  ║uz0',		'Bε = A ^ β;  ║uz0',		'R = A ^ β;  ║uz0',		'M=β,  A^M,  AM = A*M;  Ω║uz00',	'M=β,  A^M,  A = A/M;  Ω║uz0/',		'-',				'AC = AC / [α];  M=#║uz/*',
'A = A ^ 0;  ║uz0',	'[α] = A = A ^ 0;  ║uz0',	'Bε = A = A ^ 0;  ║uz0',	'R = A = A ^ 0;  ║uz0',		'M=0,  A=A^M,  AM = A*M;  Ω║0Z00',	'M=0,  A=A^M,  A = A/M;  Ω║uz0●',	'SkS:  [α]=:0NKB0,  goto α+2;',	'AC = AC / Bε, BON;  M=#║uz/*',
'A = A ^ [α];  ║uz0',	      'A = A ^ [α];  ║uz0  HAK','Bε = A = A ^ [α];  ║uz0',	'R = A = A ^ [α];  ║uz0',	'M=[α],  A=A^M,  AM = A*M;  Ω║uz0n',	'M=[α],  A=A^M,  A = A/M;  Ω║uz0/',	'-',				'AC = AC / Bε, BO;  M=#║uz/*',
'A = A ^ Bε;  ║uz0',	'[α] = A = A ^ Bε;  ║uz0',	'Bε = A = A ^ Bε;  ║uz0',	'R = A = A ^ Bε;  ║uz0',	'M=Bε,  A=A^M,  AM = A*M;  Ω║uz0n',	'M=Bε,  A=A^M,  A = A/M;  Ω║uz0/',	'Nic:',				'AC = AC / Bε, BN;  M=#║uz/*',
'A = A ^ β;  ║uz0',	'[α] = A = A ^ β;  ║uz0',	'Bε = A = A ^ β;  ║uz0',	'R = A = A ^ β;  ║uz0',		'M=β,  A=A^M,  AM = A*M;  Ω║uz00',	'M=β,  A=A^M,  A = A/M;  Ω║uz0/',	'-',				'AC = AC / Bε;  M=#║uz/*'
];

//✠=*  ⍾=;	- UWAGA na Brak znaku lub złą jego szerokość
const	alfabetPL2	= "●E≡AᴗSIU⌂DRJNFCKTZLWHYPQOBG▲MXV▼●3≡-ᴗ'87⌂*4;,!:(5+)2Ł6019?&▲./=▼";
const	alfabetPL3	= "●E≡AᴗSIU⌂DRJNFCKTZLWHYPQOBG▲MXV▼●3≡-ᴗ'87⌂*4;,!:(5+)2Ł6019?&▲./=▼●e≡aᴗsiu⌂drjnfcktzlwhypqobg▲mxv▼";
const	alfabetPL4	= "●E≡AᴗSIU⌂DRJNFCKTZLWHYPQOBG▲MXV▼●3≡-ᴗ'87⌂*4;,!:(5+)2Ł6019?&▲./=▼●e≡aᴗsiu⌂drjnfcktzlwhypqobg▲mxv▼●ę≡_ᴗ#ŹŚ⌂źĘń<ż^[Ńą]ĆłÓŻĄóć%▲>|ś▼";
const	alfabetGB2	= "●E≡AᴗSIU⌂DRJNFCKTZLWHYPQOBG▲MXV▼●3≡-ᴗ'87⌂*4;,!:(5+)2£6019?&▲./=▼";
const	alfabetGB3	= "●E≡AᴗSIU⌂DRJNFCKTZLWHYPQOBG▲MXV▼●3≡-ᴗ'87⌂*4;,!:(5+)2£6019?&▲./=▼●e≡aᴗsiu⌂drjnfcktzlwhypqobg▲mxv▼";
const	alfabetGB4	= "●E≡AᴗSIU⌂DRJNFCKTZLWHYPQOBG▲MXV▼●3≡-ᴗ'87⌂*4;,!:(5+)2£6019?&▲./=▼●e≡aᴗsiu⌂drjnfcktzlwhypqobg▲mxv▼●§≡_ᴗ#»«⌂`$µ<\\^[{±]€@}÷~°¢%▲>|\"▼";
const	alfabetDE2	= "●E≡AᴗSIU⌂DRJNFCKTZLWHYPQOBG▲MXV▼●3≡-ᴗ'87⌂*4;,Ä:(5+)2Ü6019?Ö▲./=▼";
const	alfabetFR2	= "●E≡AᴗSIU⌂DRJNFCKTZLWHYPQOBG▲MXV▼●3≡-ᴗ'87⌂*4;,É:(5+)2£6019?%▲./=▼";
const	alfabetSC2	= "●E≡AᴗSIU⌂DRJNFCKTZLWHYPQOBG▲MXV▼●3≡-ᴗ'87⌂*4;,Å:(5+)2Ö6019?Ä▲./=▼";
const	alfabetUS2	= "●E≡AᴗSIU⌂DRJNFCKTZLWHYPQOBG▲MXV▼●3≡-ᴗ@87⌂$4',!:(5\")2#6019?&▲./;▼";
const	alfabetRU3	= "●E≡AᴗSIU⌂DRJNFCKTZLWHYPQOBG▲MXV▼●3≡-ᴗ'87⌂*ЧЮ,Э:(5+)2Щ6019?Ш▲./=▼●Е≡АᴗСИУ⌂ДРЙНФЦКТЗЛВХЫПЯОБГ▲МЬЖ▼";

//sterownie krosowe dalekopisu	---w stanie sssss----	------------w stanie sssss------------
// (Poczet,Stan)=ppsssss	----nowy ppsssss-----	-------kody c3c2c1c0 wymagane do------
// (kody zmiany)=c3c2c1c0	-----po kodzie:------	----------zmiany pocztu na:-----------
// pp=0,2,4,6   sssss=0,1,...	-[ch]---▼----▲----●--	-ABC-----Abc---123₁₂₃----abc-----Ą₂₃--
const	sterAB12    = { opis:	'▼ABC▲123▼ABC▲123',
			kros: [	[0x00,0x00,0x21,0x00,	0,	0,	0o33	],		//sssss=0: ABC
				[0x21,0x00,0x21,0x21,	0o37,	0o37,	0	]]		//sssss=1: 123
};
const	sterAB12ab  = { opis:	'▼ABC▲123▼ABC▲123\n▼ABC▼abc▼Abc\n▼abc▲123▼abc\n▼abc▲▼ABC▲123▼ABC\n▲123▲▼ABC▲123▼ABC',
			kros: [	[0x00,0x42,0x21,0x00,	0,	0,	0o33,	0o37	],	//sssss=0: ABC
				[0x21,0x00,0x21,0x21,	0o37,	0o37,	0,	0o3737	],	//sssss=1: 123
				[0x42,0x02,0x24,0x42,	0o3733,	0o37,	0o33,	0	],	//sssss=2: abc
				[0x23,0x42,0x24,0x23,	0o3733,	0o3737,	0,	0o37	],	//sssss=3: ₁₂₃
				[0x23,0x00,0x24,0x23,	0o37,	0o373737,0,	0o3737	]]	//sssss=4: stan rozterki po abc▲
};
const	sterAB12abXx= { opis:	'▼ABC▲123▼ABC▲123\n▼ABC▼abc▼Abc\n▼abc▲123▼abc\n▲123▲Ą23▼abc\n▼abc▲▼ABC▲123▼ABC\n▲123▲▼ABC▲123▼ABC',
			kros: [	[0x00,0x42,0x21,0x00,	0,	0,	0o33,	0o37,	0o3333],//sssss=0: ABC
				[0x21,0x00,0x65,0x21,	0o37,	0o37,	0,	0o3737,	0o33  ],//sssss=1: 123
				[0x42,0x02,0x24,0x42,	0o3733,	0o37,	0o33,	0,	0o3333],//sssss=2: abc
				[0x23,0x42,0x65,0x23,	0o3733,	0o3737,	0,	0o37,	0o33  ],//sssss=3: ₁₂₃
				[0x23,0x00,0x64,0x23,	0o37,	0o373737,0,	0o3737,	0o33  ],//sssss=4: stan rozterki po abc▲
				[0x23,0x00,0x65,0x23,	0o37,	0o373737,0o333737,0o3737,0    ]]//sssss=5: stan rozterki po 123▲ lub ₁₂₃▲
};
const	sterAB12RU  = { opis:	'▼DIQ▲123●ДИЯ',
			kros: [	[0x00,0x00,0x21,0x42,	0,	0,	0o33,	0o40	],	//sssss=0: ABC
				[0x21,0x00,0x21,0x42,	0o37,	0o37,	0,	0o40	],	//sssss=1: 123
				[0x42,0x00,0x21,0x42,	0o37,	0o37,	0o33,	0	]]	//sssss=2: ДИЯ
};
const	typyTTY     = [	{nazwa: 'MKD-2 PL2',	jezykP:0b00000,	alfabet: alfabetPL2,	sterownia: sterAB12	},
			{nazwa: 'MKD-2 PL3',	jezykP:0b00001,	alfabet: alfabetPL3,	sterownia: sterAB12ab	},
			{nazwa: 'MKD-2 PL4',	jezykP:0b00010,	alfabet: alfabetPL4,	sterownia: sterAB12abXx	},
			{nazwa: 'ITA2 GB2',	jezykP:0b00100,	alfabet: alfabetGB2,	sterownia: sterAB12	},
			{nazwa: 'ITA2 GB3',	jezykP:0b00101,	alfabet: alfabetGB3,	sterownia: sterAB12ab	},
			{nazwa: 'ITA2 GB4',	jezykP:0b00110,	alfabet: alfabetGB4,	sterownia: sterAB12abXx	},
			{nazwa: 'ITA2 DE2',	jezykP:0b01000,	alfabet: alfabetDE2,	sterownia: sterAB12	},
			{nazwa: 'ITA2 FR2',	jezykP:0b01100,	alfabet: alfabetFR2,	sterownia: sterAB12	},
			{nazwa: 'ITA2 SC2',	jezykP:0b10000,	alfabet: alfabetSC2,	sterownia: sterAB12	},
			{nazwa: 'ITA2 US2',	jezykP:0b10100,	alfabet: alfabetUS2,	sterownia: sterAB12	},
			{nazwa: 'МТК-2 РУ3',	jezykP:0b11111,	alfabet: alfabetRU3,	sterownia: sterAB12RU	}
];
const	TTY = {	typ: -1,		// typ dalekopisu = nr w tablicy typyTTY[]
		jezykP:		0,	// język i typ sterowania pocztami znakowymi: 0,1,2=liczba dod.pocztów, 3=ster.RU
		alfabet:	'',	// alfabet dalekopisu
		alfabetU:	'',	// alfabet wg UNICODE
		krosownia:	0,	// tablica przełączeń stanów dalekopisu
		kodyWej:	0,	// kody ITA na wejściu
		widacKlaw:	false,	// czy klawiatura jest widoczna
		trybKlaw:	0x00,	// aktywne klawisze: 0x00=litery, 0x20=figury, 0x40=wszystkie
		stanShC:	0x60,	// 0x40=wciśnięty(Shift), 0x60=wciśnięty(Caps), 0x00=nie
		stanAlt:	0x00,	// 0x40=wciśnięty(Specj), 0x00=nie
		stanMon:	0x00,	// stan ITA dalekopisu = ppsssss
		daneMon:	'',	// dane wyświetlane w monitorze dalekopisu
		daneTXT:	'',	// dane wyświetlane w rejestrze tekstu
		zmianaMon:	false,	// czy zmiana danych w monitorze
		pozKaretki:	0,	// pozycja karetki w wierszu wg daneMon
		kla:		[]	// klawisze
};		{let kl = TTY.kla;
		 for (let k=71; k--;) kl[k] = document.getElementById("k"+k);
		 for (let k of [0, 2, 4, 8, 27, 31]) kl[k+32] = kl[k];
		}

const	klaWcisniety	= 'inset -1px -1px 2px rgba(255, 255, 255, .7), inset 1px 1px 2px rgba(0, 0, 0, .7)';
const	noFILE		= new Uint8Array(0);
const	BMPid		= new Uint8Array([0x42, 0x4D]);
const	BMPheader	= new Uint32Array([62 /*+32*h*/, 0, 62, 40, 255 /*256*/, 0 /*h*/, 65537, 0, 0 /*32*h*/, 2835, 2835, 0, 0, 0xFFFFFF, 0]);
let	aktywneIO	= 0;	// nr urządzenia (indeks) na potrzeby wielokrokowych operacji we/wy

const	urzIO	= [
/* 0=PTR0 */	{lamp:null, okno:null, guzv:null, szer:5, ruch:0, pozDanych:0, wysOkna:0, prePozDanych:0, dane:noFILE},
/* 1=TTR  */	{lamp:null, okno:null, guzv:null, szer:5, ruch:0, pozDanych:0, wysOkna:0, prePozDanych:0, dane:noFILE},
/* 2=PTR2 */	{lamp:null, okno:null, guzv:null, szer:5, ruch:0, pozDanych:0, wysOkna:0, prePozDanych:0, dane:noFILE},
/* 3=PTR0'*/	{lamp:null, okno:null, guzv:null, szer:8, ruch:0, pozDanych:0, wysOkna:0, prePozDanych:0, dane:noFILE},
/* 4=PTR2'*/	{lamp:null, okno:null, guzv:null, szer:8, ruch:0, pozDanych:0, wysOkna:0, prePozDanych:0, dane:noFILE},
/* 5=PTP5 */	{lamp:null, okno:null, guzv:null, szer:5, ruch:0, pozDanych:0, wysOkna:0, prePozDanych:0, dane:noFILE,	obraz:''},
/* 6=TTP  */	{lamp:null, okno:null, guzv:null, szer:5, ruch:0, pozDanych:0, wysOkna:0, prePozDanych:0, dane:noFILE,	obraz:''},
/* 7=PTP5'*/	{lamp:null, okno:null, guzv:null, szer:8, ruch:0, pozDanych:0, wysOkna:0, prePozDanych:0, dane:noFILE,	obraz:''},
/* 8=MAW  */	{lamp:null, okno:null, guzv:null,szer:255,ruch:0, poczLinii:0,konDanych:0,preKonDanych:0, dane:new Uint8Array(32), img:document.getElementById("iIO8"), guza:document.getElementById("aIO8"), daneGUZ:';-)_/\\/\\_/\\_∫'},
/* 9=TTW  */	{lamp:null, okno:null, guzv:null, szer:5, ruch:0, pozDanych:0, wysOkna:0, prePozDanych:0, dane:'',	preWysOkna:0},
/*10=TXT  */	{lamp:null, okno:null, guzv:null, caps:0, ruch:0, pozDanych:0, wysOkna:0, prePozDanych:0, dane:''},
/*11=TTK  */	{lamp:null, okno:null, guzv:null, caps:0, ruch:0, pozDanych:0, wysOkna:0, prePozDanych:0, dane:''},
];		for (let u=12; u--;) {
			let urz = urzIO[u];
			urz.lamp = document.getElementById("lIO"+u);
			urz.okno = document.getElementById("oIO"+u);
			urz.guzv = document.getElementById("vIO"+u);
		}
		urzIO[8].img.src = URL.createObjectURL( new Blob([BMPid, BMPheader], {type: 'image/bmp'}) );

const	strefyP		= [
0,	55,	110,	37,	92,	19,	74,
1,	56,	111,	38,	93,	20,	75,
2,	57,	112,	39,	94,	21,	76,
3,	58,	113,	40,	95,	22,	77,
4,	59,	114,	41,	96,	23,	78,
5,	60,	115,	42,	97,	24,	79,
6,	61,	116,	43,	98,	25,	80,
7,	62,	117,	44,	99,	26,	81,
8,	63,	118,	45,	100,	27,	82,
9,	64,	119,	46,	101,	28,	83,
10,	65,	120,	47,	102,	29,	84,
11,	66,	121,	48,	103,	30,	85,
12,	67,	122,	49,	104,	31,	86,
13,	68,	123,	50,	105,	32,	87,
14,	69,	124,	51,	106,	33,	88,
15,	70,	125,	52,	107,	34,	89,
16,	71,	126,	53,	108,	35,	90,
17,	72,	127,	54,	109,	36,	91,
18,	73];

const	opisBiegu   = [	"0: TAKT ponaglany", 
			"1: KROK ponaglany",	"2: KROK (ważki) ponaglany",	"3: CYKL ponaglany", 
			"4: KROKI stępem",	"5: KROKI (ważkie) kłusem",	"6: KROKI (ważkie) galopem", 
			"7: CYKLE kłusem",	"8: CYKLE galopem",		"9: CYKLE cwałem"
];
const	czasOddechu	= [0, 0, 0, 0,100,100, 0, 0,256000,25600000],	// czas oddechu/bezdechu
	kwantCzasu	= [0, 1, 2, 3,  1,  2, 2, 8,	 9,	  9];	// kwantyzacja biegów
const	guzWcisniety	= 'inset -2px -2px 3px rgba(255, 255, 255, .6), inset 2px 2px 3px rgba(0, 0, 0, .6)';
const	bitycechy	= 'blue';

const	guzStartB	= document.getElementById("gStartB");
const	guzStopB	= document.getElementById("gStopB");
const	guzStartM	= document.getElementById("gStartM");
const	guzStopM	= document.getElementById("gStopM");
const	guzD		= document.getElementById("gD");
const	guzK		= [];	for (let i=4; i--;) guzK[i] = document.getElementById("gK"+i);
const	guzZP		= document.getElementById("gZP");
const	guzPC		= document.getElementById("gPC");
const	guzSTOP		= document.getElementById("gSTOP");
const	guzStopAR	= document.getElementById("gStopAR");
const	guzStopNR	= document.getElementById("gStopNR");
const	guzStopNd	= document.getElementById("gStopNd");
const	guzR		= [];	for (let i=25; i--;) guzR[i] = document.getElementById("gR"+i);
const	guzZR		= document.getElementById("gZR");
const	guzA		= [];	for (let i=39; i--;) guzA[i] = document.getElementById("gA"+i);

const	lamStartB	= document.getElementById("lStartB");
const	lamStartM	= document.getElementById("lStartM");
const	lamSTART	= document.getElementById("lSTART");
const	lamU		= document.getElementById("lU");
const	lamZ		= document.getElementById("lZ");
const	lamNd		= document.getElementById("lNd");
const	lamKP		= document.getElementById("lKP");
const	lamNZ		= document.getElementById("lNZ");
const	lamA		= [];	for (let i=39; i--;) lamA[i] = document.getElementById("lA"+i);
const	lamR		= [];	for (let i=39; i--;) lamR[i] = document.getElementById("lR"+i);
const	lamSA		= [];	for (let i=13; i--;) lamSA[i]= document.getElementById("lSA"+i);
const	txtA		= [];	for (let i=7; i--;)  txtA[i] = document.getElementById("tA"+i);
let	preA		= 0;	// wyświetlona treść akumulatora A
let	preR		= 0;	// wyświetlona treść rejestru rozkazów R
let	preSA		= 0;	// wyświetlona treść rejestru SA
let	preU		= 0;	// wyświetlona treść warunku U
let	preZ		= 0;	// wyświetlona treść warunku Z
let	preNd		= 0;	// wyświetlona treść warunku Nd
let	preKP		= 0;	// wyświetlona treść warunku KP
let	preNZ		= 0;	// wyświetlona treść warunku NZ

let	modelODRA	= -1;	// 0=Odra1003, 1=Odra1003UMCS, 2=Odra1013, 3=Odra1013UMCS
let	zasilB		= 0;	// zasilanie bębna i peryferiów: 0=brak, 1=jest, -1=nakaz wyłączenia
let	zasilM		= 0;	// zasilanie maszyny: 0=brak, 1=jest, -1=nakaz wyłączenia
let	detekcjaKP	= false;// detekcja niezgodności Komputer-Program
const	blokadaK	= [false, false, false, false, false, false, false, false, false];	// blokada pamięci
let	pokazujAc	= false;// czy wyświetlać cechę liczby zmiennoprzecinkowej
let	pracaCiagla	= false;// czy CPU jest w trybie pracy ciągłej
let	stopAR		= false;// czy stopować przy zadanym AR
let	stopNR		= false;// czy stopować przy zadanym NR
let	stopNd		= false;// czy stopować przy nadmiarze stałoprzecinkowym
let	nastawaR	= 0;	// ustawienie klawiszy R (OR,AR,MR) (9+13+3)-bitowe
let	nastawaRo	= 0;	// ustawienie klawiszy R (OR)
let	nastawaRa	= 0;	// ustawienie klawiszy R (AR)
let	nastawaRm	= 0;	// ustawienie klawiszy R (MR)
let	nastawaA	= 0;	// ustawienie klawiszy A (39+1)-bitowe
let	strefaB		= 127;	// nr bieżącej strefy bębna
let	strefaBpre	= strefaB; // nr wyświetlonej strefy bębna
let	adresacja	= 1;	// adresacja komórek pamięci co 1 lub 7
let	gdzieArg	= -1;	// -1:bezArgumentu, 0:arg=0, 2:rejB, 3:N, 4:do/naPamięci, 5:zPamięciCoś, 6:zPamięciFloat
let	biegCPU		= 0;	// 0=nie biega, 1=biega, -1=nakaz stopu

let	zegarCPU	= 0;	// czas pracy komputera (liczba taktów)
let	czasCPU		= 0;	// interwał czasu CPU do oddechu (liczba taktów)
let	nowyCykl	= 0;	// 0=kontynuacjaCyklu, 1=nowyCyklOdEtapuA, 3=nowyCyklOdEtapuC, 5=czekanieNaUrządzenie
let	etapCPU;		// =krokCPUx - następna funkcja realizująca etap pracy CPU, =null - koniec cyklu
let	opisEtapu	= '';	// opis etapu pracy CPU
const	oknoZegar	= document.getElementById("oZegar");
const	oknoCPU		= document.getElementById("oCPU");
const	oknoCpuFi    = [0,	 0,	0,	0,	0,	0,	0,	0,	 7,	0,	0],	// indeksy aktualnych formatów rejestrów w oknie CPU
	oknoCpuPre   = [0.5,	 0.5,	0.5,	0.5,	0.5,	0.5,	0.5,	0.5,	 0.5,	0.5,	0.5,.5],// wartości rejestrów (i Ac) w oknie CPU
	oknoCpuVt    = [['','','','','','',"",'',''],	['','',''],['','',''],['','',''],['','',''],['','',''],['','',''],
			['','','','','','',"",'',''],['','','','','','',"",'',''],['','','','','','',"",'',''],['','','','','','',"",'','']];
const	oknoCpuF	= [],	// uchwyty pól z formatem rejestru w oknie CPU
	oknoCpuR	= [],	// uchwyty pól z dymkiem rejestru
	oknoCpuRA	= document.getElementById("oCpuRA"),	// uchwyt pola z nazwą rejestru A / AC
	oknoCpuV	= [];	// uchwyty pól z wartością rejestru
			for (let r=11; r--;) {
				oknoCpuF[r] = document.getElementById("oCpuF"+r);
				oknoCpuR[r] = document.getElementById("oCpuR"+r);
				oknoCpuV[r] = document.getElementById("oCpuV"+r);
			}
const	oknoCpuRoz	= document.getElementById("oCpuRoz");
const	oknoCpuO	= document.getElementById("oCpuO");
const	oknoCpuAc	= document.getElementById("oCpuAc");
const	oknoCpuLch	= document.getElementById("oCpuLch");
const	oknoCpuLk	= document.getElementById("oCpuLk");
const	oknoCpuU	= document.getElementById("oCpuU");
const	oknoCpuZ	= document.getElementById("oCpuZ");
const	oknoCpuNd	= document.getElementById("oCpuNd");
const	oknoCpuNZ	= document.getElementById("oCpuNZ");
const	oknoCpuKP	= document.getElementById("oCpuKP");
const	oknoCpuBP	= document.getElementById("oCpuBP");
const	oknoCpuBN	= document.getElementById("oCpuBN");
const	oknoCpuaRP	= document.getElementById("oCpuaRP");
const	oknoCpuaRN	= document.getElementById("oCpuaRN");
const	oknoCpuSAP	= document.getElementById("oCpuSAP");
const	oknoCpuSAN	= document.getElementById("oCpuSAN");
const	oknoCpuEtap	= document.getElementById("oCpuE");
const	butCPU		= document.getElementById("bCPU");
let	widoczneCPU	= false;

let	biegEmul	= 7,	// prędkość emulatora: 0123=TkKC, 456=kKK, 7=C, 89=ZZ (0123=ponaglany, 456789=auto)
	oddechBiegu	= 0,	// czas postoju pomiędzy kwantami biegu
	bezdechBiegu	= 0,	// czas pracy CPU między oddechami (czas bezdechu) kwantu 9 (wielocyklowego)
	kwantBiegu	= 8;	// 0=takt, 1=krokKażdy, 2=krokWażki, 3=cyklPonaglany, 8=cyklAuto, 9=cyklZrywny (wielocykl)
const	butDalej	= document.getElementById("bDalej");	butDalej.disabled = true; // CPU nie czeka na Dalej
const	butBieg		= document.getElementById("bBieg");	butBieg.valueAsNumber = biegEmul;
const	txtBieg		= document.getElementById("tBieg");	txtBieg.textContent = opisBiegu[biegEmul];

let blkf = 0, blkb = 0, blk1od = 0, blk1do = 0, blk2od = 0, blk2do = 0;
let divM = 0, divM0 = false, divLOper = 0;

//	układ czasu T
//	rejestr P
//	rejestr pośredniczący cechy Pc
let	rejLch		= 0;	// licznik chwil
let	rejLk		= 0;	// licznik kroków Lk
let	rejR		= 0;	// rejestr rozkazów (39+1)-bitowy
let	rejoR		// = 0;	// kod operacji 9-bitowy TPG
let	rejoRt		// = 0;	// kod operacji 3 bity T
let	rejoRp		// = 0;	// kod operacji 3 bity P
let	rejoRg		// = 0;	// kod operacji 3 bity G
let	rejaR		= 0;	// rejestr adresowy 13-bitowy - adres argumentu
let	rejnR		// = 0;	// rejestr adresowy 13-bitowy - adres następnego rozkazu
let	rejmR		// = 0;	// 3-bitowy nr rejestru B-modyfikacji
let	rejaRw		= 0;	// rejestr wybierający (uwzględniający adresację i ferryt)
let	rejaRp		= 0;	// rejestr wybierający (uwzględniający adresację)
let	rejaRs		= 0;	// numer strefy bębnowej w rejestrze wybierającym
let	rejSA		= 0;	// adres rozkazu pobranego do rejestru rozkazów
let	rejOm		= 0;	// rejestr zaokrągleń
let	rejA		= 0;	// akumulator A=Am, AM=(A,M), AC=(Am,Ac)=(A,Ac) - (39+1)-bitowy
const	rejB		= [0, 0, 0, 0, 0, 0, 0, 0];	// rejestry B-modyfikacji B0-B6,B7=M - (39+1)-bitowe
let	rejAc		= 0;	// akumulator cechy - 7-bitowy
let	rejs		= 0;	// wynik sumatora - (39+1)-bitowy
let	rejx		= 0;	// drugi argument rozkazu - (39+1)-bitowy
let	rejxm		= 0;	// mantysa drugiego argumentu rozkazu - (39+1)-bitowa
let	rejxc		= 0;	// cecha drugiego argumentu rozkazu - 7-bitowa
let	rejLOper	= 0;	// licznik kroków długich operacji
let	rejU		= false;// rejestr warunku Ujemne
let	rejZ		= false;// rejestr warunku Zero
let	rejNd		= false;// rejestr warunku Nadmiar stałoprzecinkowy
let	rejNZ		= false;// rejestr Nadmiaru Zmiennoprzecinkowego
let	rejKP		= false;// rejestr kontroli Komputer-Program

const	pamTyp		= [];
const	pamOper		= [];
const	pgmSTALY	= [
-53720647008,	-545495711840,	-519687376320,	30068437248,	83727217664,	167504245408,	26,		-545495712928,
-545460586580,	73014705692,	73014702652,	83743997440,	-519687373216,	83729052192,	-519687373888,	-511100847652,
304944248064,	304944247648,	-446676340024,	-461712655392,	-519687375712,	-461736250592,	-519687375936,	-549755813888,
47244902048,	55836669220,	-519687373248,	47244900000,	83724598272,	-511100849028,	-511135711284,	-365071961696,
-365071958720,	-328587283092,	-191156457116,	-191138891324,	-90194053120,	-545460586524,	85899607114,	-34359479204,
-34359476356,	-365071959168,	85899605450,	38620362300,	184683853184,	38620360956,	-191143086136,	390842284160,
	0,	92307190412,	-511100849540,	496066362880,	184683853184,	496050893344,	30073156512,		0,
-545460587668,	-519687373664,	465969608128,	465969608864,	-90194053120,	103079476988,	-511100849988,	-519687374752,
57964494616,	23587975676,	83750285632,	-545460585848,	30073157984,	83739539776,	-545460588188,	0,
38620888452,	390842282816,	-545460586044,	-296352483872,	23588237308,	124556147944,	124556147272,	124556145640,
124556147528,	304944250688,	304944249568,	88040797792,	23588237308,	88036605088,	47244901088,	47244901440,
2112880672,	304944250720,	304944249792,	30065294624,	30065294336,	47244898816,	47244901920,	-502510913376,
-502510912384,	-328571292024,	-328576795160,	30066078752,	30066081024,	57947716988,	-545494928800,	-328587545884,
-328587545564,	431610130588,	-545494929248,	-53720649792,	496049322912,	-53720649792,	23588500580,	496066359712,
-328590164952,	-328574700280,	92306928808,	-547608070362,	38621150696,	23588763976,	-547608071258,	23587978556,
38620888900,	128,		38621147464,	23588503428,	23588761800,	103079473220,	92306927720,	128];

let	widocznaPAM	= 0,	// 0=niePam+bezDym, 1=Pam+bezDym, 2=niePam+Dym, 3=Pam+Dym
	ustalonyAdr	= 0;
const	kolTypuPAM	= ['#000000','#A0A0A0','#00A000','#A00000','#FF8000'];	//nic,coś,float,rozkaz,ślad
const	kolAktyPAM	= ['#000000','#FFFFFF','#00FF00','#FF0000','#FFD000'];	//nic,coś,float,rozkaz,ślad
let	aRwARozPAM	= 0,
	aRpARozPAM	= 0,
	aRwAArgPAM	= 0,
	aRpAArgPAM	= 0;
const	butPAM		= document.getElementById("bPAM");
const	oknoPAM		= document.getElementById("oPAM");
const	tipPAM		= document.getElementById("tPAM");
const	cnvPAM		= document.getElementById("cPAM");
const	ctxPAM		= cnvPAM.getContext('2d');
			ctxPAM.fillStyle = kolTypuPAM[0];
			for (let i=0o20400; i--;) {
				let g = i>>>7;
				if (g !== 63) {pamOper[i] = pamTyp[i] = 0;  if (g<63) ctxPAM.fillRect((i&127)*5+1, g*4, 4, 3);}
			}
			ctxPAM.fillStyle = kolTypuPAM[1];
			for (let i=0o17600; i<0o20000; i++) {
				pamOper[i] = pgmSTALY[i-0o17600];  pamTyp[i] = 1;  ctxPAM.fillRect((i&127)*5+1, 252, 4, 3);
			}
			pamOper[0o17664] = pamOper[0o17654] += (systemWindows ? 0 : 0o2000000000) - (pamOper[0o17654] & 0o2000000000);
			{let s = strefaB*5+0.5; ctxPAM.strokeStyle = '#606060'; ctxPAM.beginPath(); ctxPAM.moveTo(s, 0); ctxPAM.lineTo(s, 256); ctxPAM.stroke(); }

const	butBeep		= document.getElementById("bBeep");
let	audioContext	= null,
	dzialaBeep	= false;



ustawWymiary();
if (typeof(Storage) !== 'undefined') {
	if (localStorage.modelODRA)	modelODRA = Number(localStorage.getItem("modelODRA")) - 1;
	if (localStorage.modelTTY)	TTY.typ   = Number(localStorage.getItem("modelTTY" )) - 1;
}
fTypTTY();
fModel();
document.body.addEventListener("keydown", eventPam);
document.body.addEventListener("keydown", eventKlaw);



function fModel() { // zmiana modelu ODRA 1003/1003UMCS/1013/1013UMCS
 if (!zasilM) {
	modelODRA = (modelODRA + 1) & 3;
	if (typeof(Storage) !== 'undefined') localStorage.setItem("modelODRA", modelODRA);
	for (let i=0o17200, f=((modelODRA >= 2) ? 0o20000 : 0o17200); i<0o17600; i++, f++) {
		ctxPAM.fillStyle = kolTypuPAM[ pamTyp[f] ];
		ctxPAM.fillRect((i&127)*5+1, (i>>>7)*4, 4, 3);
	}
	document.getElementById("logoODRA").style.backgroundImage = "url('images/logo"+modelODRA+".png')";
	if (modelODRA & 1) {
		document.getElementById("u8PTP5").style.display = "";
		document.getElementById("u8PTR0").style.display = "";
		document.getElementById("u8PTR2").style.display = "";
		document.getElementById("u5PTP5").style.marginTop = ""; 
		document.getElementById("u5PTR0").style.marginTop = ""; 
		document.getElementById("u5PTR2").style.marginTop = ""; 
		pamOper[0o17711] = pgmSTALY[0o111];
		pamOper[0o17657] = pgmSTALY[0o057];
	} else {
		document.getElementById("u8PTP5").style.display = "none";
		document.getElementById("u8PTR0").style.display = "none";
		document.getElementById("u8PTR2").style.display = "none";
		document.getElementById("u5PTP5").style.marginTop = "117px"; 
		document.getElementById("u5PTR0").style.marginTop = "103px"; 
		document.getElementById("u5PTR2").style.marginTop = "103px"; 
		pamOper[0o17711] =
		pamOper[0o17657] = -90194053664;
	}
	pamOper[0o17664] = pamOper[0o17654] += (modelODRA << 29) - (pamOper[0o17654] & 0o14000000000);
	zapalDymPam();
 }
}

function fZerZ() { // reset zegara
	zegarCPU = 0;
	zapalRejestry();
}

function fDalej() { // wykonanie następnego taktu, kroku lub cyklu
 if (!butDalej.disabled) {
	butDalej.disabled = true;
	setTimeout(petlaCPU);
 }
}

function fBeep() { // Monitor akustyczny
	if (dzialaBeep) {
		dzialaBeep = false;
		butBeep.style.boxShadow = '';
		audioContext.close();
	} else {
		dzialaBeep = true;
		butBeep.style.boxShadow = guzWcisniety;
		audioContext = new (window.AudioContext || window.webkitAudioContext)();
	}
}

function fCPU() { // trzewia CPU
	if (widoczneCPU) {
		widoczneCPU = false;
		butCPU.style.boxShadow = '';
		oknoCPU.style.visibility = 'hidden';
	} else {
		widoczneCPU = true;
		butCPU.style.boxShadow = guzWcisniety;
		zapalRejestry();
		oknoCPU.style.visibility = 'visible';
	}
}

function fCpuF(r) { // format wyświetlania rejestru CPU
	let f = oknoCpuFi[r] + 1;
	if (f >=oknoCpuVt[r].length) f = 0;
	oknoCpuFi[r] = f;
	if (r === 0) oknoCpuRA.textContent = (f === 5) ? 'AC=' : 'A =';
	oknoCpuF[r].textContent = ['bit','oct','nat','int','dec','flo','txt','TPG','Roz'][f];
	oknoCpuV[r].textContent = oknoCpuVt[r][f];
	if ((r === 0) || (r >= 7))	// rej. długie: A, M,R,s,x
		oknoCpuV[r].setAttribute ('class', f ? 'CPUw' : 'CPUw CPUwG');
}

function fPAM() { // zakamarki pamięci
	widocznaPAM ^= 1;
	if (widocznaPAM & 1) {
		butPAM.style.boxShadow = guzWcisniety;
		oknoPAM.style.visibility = 'visible';
		if (widocznaPAM >= 2) tipPAM.style.visibility = 'visible';
//		zapalRejestry();
	} else {
		butPAM.style.boxShadow = '';
		oknoPAM.style.visibility = 'hidden';
		if (widocznaPAM >= 2) tipPAM.style.visibility = '';
	}
}

function fPamM(e) { // ruch myszy
	if (widocznaPAM >= 2) return;
	let	x = Math.floor(e.offsetX / 5),
		y = Math.floor(e.offsetY / 4);
	if ((x < 0) || (x > 127) || (y < 0) || (y > 63)) return;
	let	a = y * 128 + x;
	if ((modelODRA >= 2) && ((y === 61) || (y === 62))) a += 0o600;
	if (a === ustalonyAdr) return;
	ustalonyAdr = a;
	zapalDymPam();
}

function fPamK(e) { // kliknięcie myszy w komórkę pamięci
	widocznaPAM = 3;
	tipPAM.style.visibility = 'visible';
	let	x = Math.floor(e.offsetX / 5),
		y = Math.floor(e.offsetY / 4);
	if ((x < 0) || (x > 127) || (y < 0) || (y > 63)) return;
	let	a = y * 128 + x;
	if ((modelODRA >= 2) && ((y === 61) || (y === 62))) a += 0o600;
	if (a === ustalonyAdr) return;
	ustalonyAdr = a;
	zapalDymPam();
}

function fPamD() { // kliknięcie myszy w dymek pamięci
	if (widocznaPAM >= 2)	{widocznaPAM -= 2; tipPAM.style.visibility = '';}
	else			{widocznaPAM += 2; tipPAM.style.visibility = 'visible';}
}

function eventPam(event) { // klawisze strzałek
	if (window.getComputedStyle(tipPAM).getPropertyValue('visibility') === 'hidden') return;
	let a = ustalonyAdr;
	if (a > 0o17777) a -= 0o600;
	switch(event.key) {
	 case "ArrowLeft":	a--;		break;
	 case "ArrowUp":	a -= 128;	break;
	 case "ArrowRight":	a++;		break;
	 case "ArrowDown":	a += 128;	break;
	 default:	return;
	}
	event.stopImmediatePropagation();
	a &= 0o17777;
	if ((modelODRA >= 2) && (a >= 0o17200) && (a < 0o17600)) a += 0o600;
	ustalonyAdr = a;
	zapalDymPam();
}

function zapalDymPam() { // wypełnienie dymku pamięci
	let an = ustalonyAdr,
	    v  = pamOper[an];
	if (an > 0o17777) an -= 0o600;
	let g  = an >>> 7,
	    sn = an & 127,
	    sp = strefyP[sn],
	    ap = g * 128 + sp;
	let bT = v & 1;
	v = (v - bT) / 2;
	let w = v + 0o30000000000000,
	    b = w.toString(2),
	    o = w.toString(8),
	    n = (((v >>> 1) & 0o177777) + 0o1000000).toString(8);
	let vn = (v >>> 17) & 0o17777,
	    va = vn.toString(),
	    vb = va,
	    vg = (vn & 255).toString(),
	    vd = (vn & 63).toString(),
	    vm = n.substr(6),
	    ve = vm,
	    vz = '0';
	if (v & 1) {
		vz = '1';
		if (vm !== '6') {
			if (ve === '7') ve = '?';
			let vr='+B'+ve;	va += vr;		vb = '(' + va + ')';
			vr += ')';	vg = '(' + vg + vr;	vd = '(' + vd + vr;
		}
	}
	let vt = Math.floor(v/16),
	    t = '',
	    tt = ["│", "│", "│", "│"],
	    al = TTY.alfabet.length / 32;
	for (let i=7; i--;) {
		let c = vt & 31;
		vt = (vt - c) / 32;
		for (let j=al; j--;) tt[j] = TTY.alfabet.charAt(j*32+c) + tt[j];
	}
	for (let j=0; j<al; j++) t += " │" + tt[j];
	tipPAM.textContent = ' Adr.N = ' + (an + 0o100000).toString(8).substr(1) + ' = ' + (g + 0o100).toString(8).substr(1) + ':' + (sn + 0o1000).toString(8).substr(1) +
			   '\n     P = ' + (ap + 0o100000).toString(8).substr(1) + ' =   :' + (sp + 0o1000).toString(8).substr(1) +
		'\nbit= ' + b.substr(2,1) + '.' + b.substr(3) + (bT ? '_1' : '_0') +
		'\noct= ' + o.substr(1) +
		'\nnat= ' + ((v<0) ? (v+0o10000000000000) : v).toString() +
		'\nint= ' + v.toString() +
		'\ndec= ' + (v / 0o4000000000000).toString() +
		'\nflo= ' + (Math.floor(v/128) * 2 ** (((v << 25) >> 25) - 31)).toString() +
		'\ntxt= ' + t.substr(1) +
		'\nTPG= ' + ':' + o.substr(1,3) + ' ' + (((v >>> 17) & 0o17777) + 0o100000).toString(8).substr(1) + ' ' + n.substr(1,5) + ' ' + vm + vz +
		'\nRozkaz ' + (opisRozkazu[Math.floor(v/0o10000000000) & 0o777]).replace(/[αβγδε]/g, znak => ({'α': va, 'β': vb, 'γ': vg, 'δ': vd, 'ε': ve})[znak]);
	let rogi = 0;
	if (sn > 63) {tipPAM.style.right = ((128-sn)*5)+'px'; tipPAM.style.left  = 'auto'; rogi = 1;}
	else	     {tipPAM.style.left  = ((sn+1)  *5)+'px'; tipPAM.style.right = 'auto';}
	if (g > 31)  {tipPAM.style.bottom= ((64-g)*4)  +'px'; tipPAM.style.top   = 'auto'; rogi += 2;}
	else	     {tipPAM.style.top   = ((g+1) *4)  +'px'; tipPAM.style.bottom= 'auto';}
	tipPAM.style.borderRadius = ["0px 8px 8px 8px", "8px 0px 8px 8px", "8px 8px 8px 0px", "8px 8px 0px 8px"][rogi];
}

function fBieg() { // zmiana biegu emulatora
        biegEmul = butBieg.valueAsNumber;
	txtBieg.textContent = opisBiegu[biegEmul];
	kwantBiegu = kwantCzasu[biegEmul];
	bezdechBiegu = oddechBiegu = czasOddechu[biegEmul];
	if (kwantBiegu === 9)	oddechBiegu = 0;
//	else			bezdechBiegu = 0;
	if ((!butDalej.disabled) && (biegEmul > 3)) {
		butDalej.disabled = true;
		setTimeout(petlaCPU);
	}
}

function fStartB() { // włączenie zasilania bębna i peryferiów
 if (!zasilB) {
	zasilB = 1;
	guzStartB.style.boxShadow = guzWcisniety;
	guzStopB.style.boxShadow = '';
	lamStartB.setAttribute ('class','lam lam1');
	for (let u of [5, 7, 9, 11]) {
		let urz = urzIO[u];
		urz.lamp.setAttribute ('class','lIO lam1');
		urz.ruch = 1;
	}
 }
}

function fStartM() { // włączenie maszyny
 if (zasilB && !zasilM) {
	zasilM = 1;
	guzStartM.style.boxShadow = guzWcisniety;
	guzStopM.style.boxShadow = '';
	lamStartM.setAttribute ('class','lam lam1');
 }
}

function fStopM() { // wyłączenie maszyny
 if (zasilM) {
	guzStopM.style.boxShadow = guzWcisniety;
	if (biegCPU) {
		if (zasilM > 0) { zasilM = -1; fStopCPU(); }
	} else {
		zasilM = 0;
		for (let i=0o20000; i<0o20400; i++) pamOper[i] = pamTyp[i] = 0;
		ctxPAM.fillStyle = kolTypuPAM[pamTyp[aRwARozPAM]];	ctxPAM.fillRect((aRpARozPAM&127)*5+1, (aRpARozPAM>>>7)*4, 4, 3);
		ctxPAM.fillStyle = kolTypuPAM[pamTyp[aRwAArgPAM]];	ctxPAM.fillRect((aRpAArgPAM&127)*5+1, (aRpAArgPAM>>>7)*4, 4, 3);
		aRwARozPAM = aRpARozPAM = aRwAArgPAM = aRpAArgPAM = 0;
		if (modelODRA >= 2) {
			ctxPAM.fillStyle = kolTypuPAM[0];
			for (let i=0o17200; i<0o17600; i++) ctxPAM.fillRect((i&127)*5+1, (i>>>7)*4, 4, 3);
		}
		if (ustalonyAdr >= 0o20000) zapalDymPam();
		for (let i=8; --i;) rejB[i] = 0;
		rejSA = rejaR = rejR = rejA = rejAc = rejx = rejs = rejOm = rejLk = rejLch = 0;
		rejU = rejZ = rejNd = rejKP = rejNZ = false;
		for (let i=12; i--;) oknoCpuPre[i] = 0.5;
		// wyzerować pomocnicze rejestry
		zapalRejestry();
		lamStartM.setAttribute ('class','lam lam0');
		guzStartM.style.boxShadow = guzStopM.style.boxShadow = '';
		if (zasilB < 0) fStopB();
	}
 }
}

function fStopB() { // wyłączenie zasilania bębna i peryferiów
 if (zasilB) {
	guzStopB.style.boxShadow = guzWcisniety;
	if (zasilM) {
		if (zasilB > 0) { zasilB = -1; fStopM(); }
	} else {
		zasilB = 0;
		for (let u=12; u--;) {
			let urz = urzIO[u];
			urz.lamp.setAttribute ('class','lIO lam0');
			urz.ruch = 0;
		}
// wyczyścić TTMon
		strefaB	= 127;
		zapalRejestry();
		lamStartB.setAttribute ('class','lam lam0');
		guzStartB.style.boxShadow = guzStopB.style.boxShadow = '';
	}
 }
}

function fPP() { // przygotowanie pracy
 if (zasilM) {
	strefaB = 127;
	zapalRejestry();
 }
}

function fD() { // Detekcja Komputer-Program
	guzD.style.boxShadow = ((detekcjaKP = !detekcjaKP) ? guzWcisniety : '');
}

function wymaganaODRA1013() {
	opisEtapu = 'NIC NIE RÓB - Wymagana ODRA 1013';
	if (detekcjaKP) {rejKP = true; biegCPU = -1; }
}

function wymaganaODRAUMCS() {
	opisEtapu = 'NIC NIE RÓB - Wymagana ODRA UMCS';
	if (detekcjaKP) {rejKP = true; biegCPU = -1; }
}

function fK(i) { // blokada zapisu do pamięci
	guzK[i].style.boxShadow = ((blokadaK[i] = !blokadaK[i]) ? guzWcisniety : '');
}

function blokadaPam(aRw) { // czy komórka pamięci zablokowana 
	if (blokadaK[aRw >>> 10])		 { opisEtapu = 'Nie zapisano - Blokada pamięci'; return 2; }
	if (((aRw >>> 7) === 0o77) && modelODRA) { opisEtapu = 'Nie zapisano - Ochrona programu STAŁEGO'; return 1; }
	return 0;
}

function sprawdzDziel(dz) {
	if (dz) {
		let d = rejA / dz;
		if ((d < -1) || (d >= 1)) {
			opisEtapu = 'Dzielenie niewykonalne';
			rejNd = true;
			if (stopNd) biegCPU = -1;
		}
	} else {
		opisEtapu = 'Dzielenie przez zero';
		rejNd = true;
		biegCPU = -1;
	}
}

function fZP() { // wyświetlanie cechy zmiennoprzecinkowej Ac
	let w = '',
	    t = '';
	if (pokazujAc = !pokazujAc) { w = guzWcisniety; t = bitycechy; }
	guzZP.style.boxShadow = w;
	for (let i=7; i--;) txtA[i].style.color = t;
	zapalRejestry();
}

function fPC() { // Praca Ciągła
	guzPC.style.boxShadow = ((pracaCiagla = !pracaCiagla) ? guzWcisniety : '');
}

function fzdoA(o) { // przesłanie z Akumulatora do pamięci lub odwrotnie
 if (zasilM && !biegCPU) {
//	opisEtapu = ((o === 0o401) ? 'Rozkaz przyciskiem "zA" z pulpitu' : 'Rozkaz przyciskiem "doA" z pulpitu');
	lamSTART.setAttribute ('class','lam lam1');
	let n = nastawaRo;
	nastawaRo = o;
	fLadR();
	nastawaRo = n;
	biegCPU = -1;
	nowyCykl = 3;
	setTimeout(petlaCPU);
 }
}

function fO() { // wykonanie Operacji ustawionej na klawiszach rejestru rozkazów
 if (zasilM && !biegCPU) {
//	opisEtapu = 'Rozkaz przyciskiem "O" z pulpitu';
	lamSTART.setAttribute ('class','lam lam1');
	fLadR();
	biegCPU = -1;
	nowyCykl = 3;
	setTimeout(petlaCPU);
 }
}

function fLadR() { // Ładuj rejestr Rozkazów
 if (zasilM && !biegCPU) {
	let n = ((nastawaRo << 23) * 0o400) + (nastawaRa * 0o1000000) + (nastawaRm * 4),
	    k = rejR & 0o777742;
	rejR = n + (((rejR - k) === n) ? (((n >>> 13) & 0o777740) + (k&2)) : k);
	rozparcelujR();
	zapalRejestry();
 }
}

function fZerR() { // Zeruj rejestr Rozkazów
 if (zasilM && !biegCPU) {
	rejR = 0;
	rozparcelujR();
	zapalRejestry();
 }
}

function fLadA() { // Ładuj Akumulator
 if (zasilM && !biegCPU) {
	rejA = nastawaA;
	zapalRejestry();
 }
}

function fZerA() { // Zeruj Akumulator
 if (zasilM && !biegCPU) {
	rejA = 0;
	zapalRejestry();
 }
}

function fStopAR() { // Stop po rozkazie z zadanym adresem AR
	guzStopAR.style.boxShadow = ((stopAR = !stopAR) ? guzWcisniety : '');
}

function fStopNR() { // Stop po rozkazie z zadanym adresem NR
	guzStopNR.style.boxShadow = ((stopNR = !stopNR) ? guzWcisniety : '');
}

function fStopNd() { // Stop przy Nadmiarze stałoprzecinkowym
	guzStopNd.style.boxShadow = ((stopNd = !stopNd) ? guzWcisniety : '');
}

function fZR() { // Zmiana Reżimu adresacji pamięci
	guzZR.style.boxShadow = (((adresacja = 8 - adresacja) === 7) ? guzWcisniety : '');
}

function fR(i) { // nastawienie klawiszy R (OR,AR,MR)
	let b = 1 << i;
	nastawaR ^= b;
	guzR[i].style.boxShadow = ((nastawaR & b) ? guzWcisniety : '');
	nastawaRo = nastawaR >>> 16;
	nastawaRa = (nastawaR >>> 3) & 0o17777;
	nastawaRm = nastawaR & 7;
}

function fA(i) { // nastawienie klawiszy A
	let d = nastawaA & 255,
	    g = nastawaA - d,
	    b = 1;
	if (i < 7) {
		b <<= (i+1);	d ^= b; b &= d;
	} else {
		g /= 256;
		b <<= (i-7);	g ^= b; b &= g;
		g *= 256;
	}
	nastawaA = g + d;
	guzA[i].style.boxShadow = (b ? guzWcisniety : '');
}

function zapalRejestry() { // wyświetlenie stanu komputera
	let c = rejSA,
	    z = preSA ^ c;
	preSA = c;
	for (let i=0; z; i++, c>>>=1, z>>>=1) {
		if (z&1) lamSA[i].setAttribute ('class', ((c&1) ? 'lam lam1' : 'lam lam0'));
	}
	let r = rejR & 0o17777777777,
	    p = preR & 0o17777777777;
	c = r >> 1;
	z = (p >> 1) ^ c;
	for (let i=0; z; i++, c>>>=1, z>>>=1) {
		if (z&1) lamR[i].setAttribute ('class', ((c&1) ? 'lam lam1' : 'lam lam0'));
	}
	c = (rejR - r) / 0o20000000000;
	z = (((preR - p) / 0o20000000000) ^ c) & 0o777;
	preR = rejR;
	for (let i=30; z; i++, c>>>=1, z>>>=1) {
		if (z&1) lamR[i].setAttribute ('class', ((c&1) ? 'lam lam1' : 'lam lam0'));
	}
	r = rejA & 0o377;
	p = preA & 0o377;
	let e = (pokazujAc ? (rejAc & 0o177) : (r >> 1));
	c = e;
	z = (p >> 1) ^ c;
	for (let i=0; z; i++, c>>>=1, z>>>=1) {
		if (z&1) lamA[i].setAttribute ('class', ((c&1) ? 'lam lam1' : 'lam lam0'));
	}
	c = (rejA - r) / 0o400;
	z = ((preA - p) / 0o400) ^ c;
	preA = rejA - r + (e * 2);
	for (let i=7; z; i++, c>>>=1, z>>>=1) {
		if (z&1) lamA[i].setAttribute ('class', ((c&1) ? 'lam lam1' : 'lam lam0'));
	}
	if (rejU !== preU) { preU = rejU; lamU.setAttribute ('class', (rejU ? 'lam lam1' : 'lam lam0')); }
	if (rejZ !== preZ) { preZ = rejZ; lamZ.setAttribute ('class', (rejZ ? 'lam lam1' : 'lam lam0')); }
	if (rejNd !== preNd) { preNd = rejNd; lamNd.setAttribute ('class', (rejNd ? 'lam lam1' : 'lam lam0')); }
	if (rejKP !== preKP) { preKP = rejKP; lamKP.setAttribute ('class', (rejKP ? 'lam lam1' : 'lam lam0')); }
	if (rejNZ !== preNZ) { preNZ = rejNZ; lamNZ.setAttribute ('class', (rejNZ ? 'lam lam1' : 'lam lam0')); }
	c = czasCPU = zegarCPU;
	z = c % 15360000;
	p = (c - z) / 15360000;
	r = p % 60;
	oknoZegar.textContent = ((p-r)/60).toString() + ":" + (r+100).toString().substr(1,2) + ":" + (z/256000+100).toFixed(8).substr(1);//toFixed(kwantBiegu? 8 : 11)
	if (widocznaPAM & 1) {
	    let	s = strefaBpre*5+0.5; ctxPAM.strokeStyle = '#404040'; ctxPAM.beginPath(); ctxPAM.moveTo(s, 0); ctxPAM.lineTo(s, 256); ctxPAM.stroke();
		s = strefaB   *5+0.5; ctxPAM.strokeStyle = '#606060'; ctxPAM.beginPath(); ctxPAM.moveTo(s, 0); ctxPAM.lineTo(s, 256); ctxPAM.stroke();
		strefaBpre = strefaB;
	}
	if (widoczneCPU) {
		oknoCpuO.textContent  = (rejOm ? '1' : '0');
		oknoCpuAc.textContent = rejAc;
		oknoCpuLch.textContent= rejLch;
		oknoCpuU.textContent  = (rejU ? 'U' : '');
		oknoCpuZ.textContent  = (rejZ ? 'Z' : '');
		oknoCpuNd.textContent = (rejNd ? 'Nd' : '');
		oknoCpuNZ.textContent = (rejNZ ? 'NZ' : '');
		oknoCpuKP.textContent = (rejKP ? 'KP' : '');
		oknoCpuLk.textContent = rejLk;
		oknoCpuBP.textContent = strefyP[strefaB].toString(8);
		oknoCpuBN.textContent = strefaB.toString(8);
		oknoCpuaRP.textContent= (rejaR + 0o100000).toString(8).substr(1);
		oknoCpuaRN.textContent= ((rejaR >>> 7) + 0o100).toString(8).substr(1) + ':' + (((rejaR * adresacja) & 0o177) + 0o1000).toString(8).substr(1);
		oknoCpuSAP.textContent= (rejSA + 0o100000).toString(8).substr(1);
		oknoCpuSAN.textContent= ((rejSA >>> 7) + 0o100).toString(8).substr(1) + ':' + (((rejSA * adresacja) & 0o177) + 0o1000).toString(8).substr(1);
		oknoCpuEtap.textContent = opisEtapu;
		for (let r=7; --r;) {
			let v = rejB[r];
			if (v !== oknoCpuPre[r]) {
				oknoCpuPre[r] = v;
				v >>>= 18;
				let oVt = oknoCpuVt[r];
				oVt[0] = (v+0o20000).toString(2).substr(1);
				oVt[1] = (v+0o100000).toString(8).substr(1);
				oVt[2] = v.toString();
				oknoCpuV[r].textContent = oVt[oknoCpuFi[r]]; 
				oknoCpuR[r].textContent = ' Wartość ' + ['A = Am','B1','B2','B3','B4','B5','B6','M = B7','R','s','x'][r] +
					'\nbit= ' + oVt[0] + '\noct= ' + oVt[1] + '\nnat= ' + oVt[2]; 
			}
		}
		let rej = [rejA, , , , , , , rejB[7], rejR, rejs, rejx];
		r = 10;
		do {	let v = rej[r];
			if (v !== oknoCpuPre[r]) {
				oknoCpuPre[r] = v;
				let bT = v & 1;
				v = (v - bT) / 2;
				let oVt = oknoCpuVt[r],
				    w = v + 0o30000000000000,
				    b = w.toString(2),
				    o = w.toString(8),
				    n = (((v >>> 1) & 0o177777) + 0o1000000).toString(8);
				oVt[0] = b.substr(2,1) + '.' + b.substr(3) + (bT ? '_1' : '_0');
				oVt[1] = o.substr(1);
				oVt[2] = ((v<0) ? (v+0o10000000000000) : v).toString();
				oVt[3] = v.toString();
				oVt[4] = (v / 0o4000000000000).toString();
				if (r)
					oVt[5] = (Math.floor(v/128) * 2 ** (((v << 25) >> 25) - 31)).toString();
				else
					oVt[5] = (v * 2 ** (rejAc - 38)).toString();
				let vn = (v >>> 17) & 0o17777,
				    va = vn.toString(),
				    vb = va,
				    vg = (vn & 255).toString(),
				    vd = (vn & 63).toString(),
				    vm = n.substr(6),
				    ve = vm,
				    vz = '0';
				if (v & 1) {
					vz = '1';
					if ((r !== 8) && (vm !== '6')) {
						if (ve === '7') ve = '?';
						let vr='+B'+ve;	va += vr;		vb = '(' + va + ')';
						vr += ')';	vg = '(' + vg + vr;	vd = '(' + vd + vr;
					}
				}
				oVt[7] = ':' + o.substr(1,3) + ' ' + (((v >>> 17) & 0o17777) + 0o100000).toString(8).substr(1) + ' ' + n.substr(1,5) + ' ' + vm + vz;
				oVt[8] = (opisRozkazu[Math.floor(v/0o10000000000) & 0o777]).replace(/[αβγδε]/g, znak => ({'α': va, 'β': vb, 'γ': vg, 'δ': vd, 'ε': ve})[znak]);
				if (r === 8) oknoCpuRoz.textContent = oVt[8];
				v = Math.floor(v/16);
				let t = '',
				    tt = ["│", "│", "│", "│"],
				    al = TTY.alfabet.length / 32;
				for (let i=7; i--;) {
					let c = v & 31;
					v = (v - c) / 32;
					for (let j=al; j--;) tt[j] = TTY.alfabet.charAt(j*32+c) + tt[j];
				}
				for (let j=0; j<al; j++) t += " │" + tt[j];
				oVt[6] = t.substr(1);					
				oknoCpuV[r].textContent = oVt[oknoCpuFi[r]]; 
				oknoCpuR[r].textContent = ' Wartość ' + ['A = Am','B1','B2','B3','B4','B5','B6','M = B7','R','s','x'][r] +
					'\nbit= ' + oVt[0] + '\noct= ' + oVt[1] + '\nnat= ' + oVt[2] + '\nint= ' + oVt[3] + '\ndec= ' + oVt[4] + '\nflo= ' + oVt[5] + '\ntxt= ' + oVt[6] + '\nTPG= ' + oVt[7] + '\nRozkaz ' + oVt[8];
			}
			if (r === 7) {
				r = 1;
				if (rejAc !== oknoCpuPre[11]) {oknoCpuPre[11] = rejAc; oknoCpuPre[0] = 0.5;}
			}
		} while (r--);
	}
	for (let u=5; u--;) {
		let urz = urzIO[u],
		    p = urz.pozDanych;
		if (p !== urz.prePozDanych) {
			let o = urz.okno,
			    s = urz.szer + 2;
			urz.prePozDanych = p;
			o.scrollTop = (p - 1) * pfontHeight;
			o.setSelectionRange(p *= s, p + s);
			urz.guzv.textContent = o.value.substr(p - s, s-1);
		}
	}
	if (TTY.zmianaMon) {
		let urz9 = urzIO[9],
		    urz10= urzIO[10];
		urz9.guzv.textContent = TTY.daneMon;
		if (TTY.widacKlaw) ustawKlawisze();
		TTY.zmianaMon = false;
		let p = urz10.pozDanych;
		if (p !== urz10.prePozDanych) {
			urz10.okno.setSelectionRange(p, p + 1);
			urz10.prePozDanych = p;
			urz10.guzv.textContent = TTY.daneTXT;
		}
		let l = urz9.dane.length;
		if (l !== urz9.prePozDanych) {
			let o = urz9.okno,
			    h = urz9.wysOkna;
			o.textContent = urz9.dane;
			urz9.prePozDanych = l;
			if (h !== urz9.preWysOkna) {
				o.style.height = h + 'px';
				o.scrollTop = o.scrollHeight;
				urz9.preWysOkna = h;
			}
		}
	}
	for (let u=5; u<8; u++) {
		let urz = urzIO[u],
		    p = urz.pozDanych;
		if (p !== urz.prePozDanych) {
			let o = urz.okno,
			    s = urz.szer + 2;
			o.textContent = urz.obraz;
			o.style.height = urz.wysOkna + 'px';
			o.scrollTop = o.scrollHeight;
			urz.prePozDanych = p;
			urz.guzv.textContent = o.value.substr((p-1)*s, s-1);
		}
	}
	{let urz = urzIO[8],
	     hw = urz.konDanych;
	 if (hw !== urz.preKonDanych) {
		let h = hw / 32;
		BMPheader[8] = hw;
		BMPheader[0] = 62 + hw;
		BMPheader[5] = urz.img.height = h;	// urz.img.width = ;
		urz.okno.style.height = Math.max(h+4, fontHeight) + 'px';
		URL.revokeObjectURL(urz.img.src);
		urz.img.src = URL.createObjectURL( new Blob([BMPid, BMPheader, urz.dane.slice(0, hw)], {type: 'image/bmp'}) );
		urz.preKonDanych = hw; 
		urz.guzv.textContent = urz.daneGUZ.substr(3);
	 }
	}
}

function rozparcelujR() { // podział rozkazu na części
	let R = rejR,
	    a = R & 0o17777777777,
	    o = rejoR = ((R - a) / 0o20000000000) & 0o777;
	rejoRt = o >>> 6;
	rejoRp =(o >>> 3) & 7;
	rejoRg = o & 7;
	rejaR = a >>> 18;
	rejnR = (R >>> 5) & 0o17777;
	rejmR = (R >>> 2) & 7;
}

function fStopCPU() { // zatrzymanie maszyny
 if (biegCPU > 0) {
	biegCPU = -1;
	guzSTOP.style.boxShadow = guzWcisniety;
 }
}

function fStartCPU() { // wystartowanie maszyny
 if (zasilM && !biegCPU) {
	lamSTART.setAttribute ('class','lam lam1');
	rejNZ = rejKP = false;
	biegCPU = 1;
	nowyCykl = 1;
	setTimeout(petlaCPU);
 }
}

function petlaCPU() { // Pętla główna sterowania
cykl:do {
	if (nowyCykl) {
		rejaRw = rejaRp = (rejaR & 0o17600) + (rejaRs = (rejaR * adresacja) & 0o177); 
		if ((modelODRA >= 2) && (rejaRw >= 0o17200) && (rejaRw < 0o17600)) rejaRw += 0o600; 
		gdzieArg = -1;
		rejLk = rejLch = 0;
		if (nowyCykl === 1) {	etapCPU = krokCPUa;	opisEtapu = 'Czekanie na rozkaz'; }
		else			etapCPU = krokCPUc;
		nowyCykl = 0;
	}
   krok:do {
		let t = etapCPU();
		zegarCPU += t;
		t += rejLch;
		let z = rejLch = t % 40;
		rejLk += t = (t - z) / 40;
		strefaB = (strefaB + t) & 0o177;
		if (etapCPU === null) {
			if (nowyCykl === 0) {nowyCykl = 1; rejaR = rejnR;}
			// else		Następny Rozkaz już jest w R z sumatora
			if ((biegCPU > 0) && pracaCiagla) {
				if ((kwantBiegu === 9) && ((zegarCPU - czasCPU) < bezdechBiegu)) continue cykl;
				zapalRejestry();
				if (biegEmul>3)	setTimeout(petlaCPU, oddechBiegu);
				else		butDalej.disabled = false;
			} else {
				zapalRejestry();
				biegCPU = 0;
				if (dzialaBeep && pracaCiagla) {
					let oscillator	= audioContext.createOscillator(),
					    gainNode	= audioContext.createGain();
					oscillator.connect(gainNode);			//oscillator.connect(audioContext.destination);
					gainNode.connect(audioContext.destination);
					gainNode.gain.value = 0.25;
					//oscillator.type = "sine";
					//oscillator.frequency.value = 440;
					oscillator.start();
					oscillator.stop(audioContext.currentTime + 1);
				}
				if (zasilM < 0) fStopM();
				lamSTART.setAttribute ('class','lam lam0');
				guzSTOP.style.boxShadow = '';
			}
		} else {
			if (nowyCykl === 5) {nowyCykl = 0; zapalRejestry();}
			else {
				if ((kwantBiegu >= 3) || (z && biegEmul)) continue krok;
				zapalRejestry();
				if (biegEmul>3)	setTimeout(petlaCPU, oddechBiegu);
				else		butDalej.disabled = false;
			}
		}
		return;
	} while (true);
     } while (true);
}

function krokCPUa() { // (a) Wybór rozkazu
	let k = 1;
	if ((rejaRw < 0o20000) && (kwantBiegu > 1)) {
		k = rejaRs - strefaB;
		if (k < 1) k += 128;
	}
	if ((rejaRw >= 0o20000) || (((strefaB + k) & 0o177) === rejaRs)) {
		rejSA = rejaR;
		etapCPU = krokCPUb;
		opisEtapu = 'Pobieranie rozkazu';
	}
	return k * 40;
}

function krokCPUb() { // (b) Pobranie rozkazu
	rejR = pamOper[rejaRw];
//	if (widocznaPAM & 1) {
		ctxPAM.fillStyle = kolTypuPAM[pamTyp[aRwARozPAM]];
		ctxPAM.fillRect((aRpARozPAM&127)*5+1, (aRpARozPAM>>>7)*4, 4, 3);
		let aRw = aRwARozPAM = rejaRw,
		    aRp = aRpARozPAM = rejaRp;
		if (pamTyp[aRw] < 3) pamTyp[aRw] = 3;
		ctxPAM.fillStyle = kolAktyPAM[pamTyp[aRw]];
		ctxPAM.fillRect((aRp&127)*5+1, (aRp>>>7)*4, 4, 3);
//	}
	if (rejR & 2) {
		let m = (rejR >>> 2) & 7,
		    b = rejB[m];
		if (m === 6) b /= 0o20000;
		rejR += b;
		opisEtapu = 'Rozkaz pobrany z B-modyfikacją';
	} else
		opisEtapu = 'Rozkaz pobrany';
	rozparcelujR();
	rejaRw = rejaRp = (rejaR & 0o17600) + (rejaRs = (rejaR * adresacja) & 0o177); 
	if ((modelODRA >= 2) && (rejaRw >= 0o17200) && (rejaRw < 0o17600)) rejaRw += 0o600; 
	etapCPU = krokCPUc;
	return 40;
}

function krokCPUc() { // (c) Wybór argumentu rozkazu
	let k = 1;
	if (gdzieArg < 4) {
		let gx = -1;
		switch(rejoRg) {
		 case 7:if (rejoRt) {
				if (rejoRt ===2) {if (rejoRp < 4) gx = 4;}
				else		 gx = (rejoRp < 4 ? 6 : 2);
			}
			break;
		 case 6:if ((rejoR === 0o746) || ((rejoRp === 3) && rejoRt && (rejoRt <= 4))) gx = 4;
			break;
		 default:gx = rejoRp & 3;
		}
		switch(gx) {
		 case 0: rejx = 0;		break;
		 case 2: rejx = rejB[rejmR];	break;
		 case 3: rejx = rejaR * 0o1000000;
		}
		if (gx === 1)	gx = 5;
		else		if (rejoRg === 1) gx = 4;
		gdzieArg = gx;
		opisEtapu = 'Czekanie na pamięć';
	}
	if (gdzieArg < 4) {
		opisEtapu = 'Argumenty gotowe';
		etapCPU = krokCPUd;
	} else {
		if ((rejaRw < 0o20000) && (kwantBiegu > 1)) {
			k = rejaRs - strefaB;
			if (k < 1) k += 128;
		}
		if ((rejaRw >= 0o20000) || (((strefaB + k) & 0o177) === rejaRs)) {
			if (gdzieArg === 4)
				opisEtapu = 'Argument osiągnięty';
			else { //gdzieArg === 5, 6
				opisEtapu = 'Argument pobrany';
				rejx = pamOper[rejaRw];
//				if (widocznaPAM & 1) {
					ctxPAM.fillStyle = kolTypuPAM[pamTyp[aRwAArgPAM]];
					ctxPAM.fillRect((aRpAArgPAM&127)*5+1, (aRpAArgPAM>>>7)*4, 4, 3);
					let aRw = aRwAArgPAM = rejaRw,
					    aRp = aRpAArgPAM = rejaRp;
					ctxPAM.fillStyle = kolAktyPAM[pamTyp[aRw] = gdzieArg - 4];
					ctxPAM.fillRect((aRp&127)*5+1, (aRp>>>7)*4, 4, 3);
//				}
			}
			etapCPU = krokCPUd;
		}
	}
	return k * 40;
}

function krokCPUd() { // (d) Wykonanie rozkazu
	if ((stopAR && (rejaR === nastawaRa)) || (stopNR && (rejnR === nastawaRa))) biegCPU = -1;
	opisEtapu = 'Rozkaz wykonany';
	if (rejoRg < 6) {
		switch(rejoRt) {
		 case 0: rejs = rejx;		break;
		 case 1: rejs = -rejx;		break;
		 case 2: rejs = Math.abs(rejx);	break;
		 case 3: rejs = rejA - rejx;	break;
		 case 4: rejs = rejA + rejx;	break;
		 case 5: rejs = rejx - rejA;	break;
		 case 6:{//rejs=rejA ∧ rejx;
			 let a = rejA & 0o377, x = rejx & 0o377;
			 rejs = (((rejA-a)/0o400) & ((rejx-x)/0o400)) * 0o400 + (a & x);
			}
			 break;
		 default:{//rejs=rejA ÷ rejx;
			 let a = rejA & 0o377, x = rejx & 0o377;
			 rejs = (((rejA-a)/0o400) ^ ((rejx-x)/0o400)) * 0o400 + (a ^ x);
			}
		}
		rejU = rejs < 0;
		rejZ = rejs === 0;
		if ((rejs >= -0o10000000000000) && (rejs < 0o10000000000000))
			rejNd = false;
		else {	rejNd = true;
			if (stopNd) biegCPU = -1;
			let s = rejs & 0xFF;
			rejs = (((rejs-s) / 256) | 0) * 256 + s;
		}
		if (rejoRp > 3)	rejA = rejs;
		switch(rejoRg) {
		 case 1:// wynik do pamięci
			if ((rejoRp === 1) || (rejoRp === 5)) break; // TPG x11,x51 jak x10,x50
			if (blokadaPam(rejaRw) === 0) {
				pamOper[rejaRw] = rejs;
//				if (widocznaPAM & 1) {
					ctxPAM.fillStyle = kolTypuPAM[pamTyp[aRwAArgPAM]];
					ctxPAM.fillRect((aRpAArgPAM&127)*5+1, (aRpAArgPAM>>>7)*4, 4, 3);
					let aRw = aRwAArgPAM = rejaRw,
					    aRp = aRpAArgPAM = rejaRp;
					ctxPAM.fillStyle = kolAktyPAM[pamTyp[aRw] = 1];
					ctxPAM.fillRect((aRp&127)*5+1, (aRp>>>7)*4, 4, 3);
					if (ustalonyAdr === aRw) zapalDymPam();
//				}
			}
			break;
		 case 2:// wynik do rejestru B
			if (rejmR ===7)	rejB[7] = rejs;
			else if (rejmR)	rejB[rejmR] = rejs & 0o17777000000;
			break;
		 case 3:// wynik do rejestru R
			rejR = rejs;
			rozparcelujR();
			opisEtapu = 'Rozkaz z sumatora';
			nowyCykl = 3;
			break;	//etapCPU = null;return 40;
		 case 4:etapCPU = krokCPUdMul;
			opisEtapu = 'Trwa mnożenie stałoprzecinkowe';
			rejB[7] = rejx;
			rejLOper = 42;
			return 40;
		 case 5:etapCPU = krokCPUdDiv;
			opisEtapu = 'Trwa dzielenie stałoprzecinkowe';
			sprawdzDziel(rejB[7] = rejx);
			divLOper = rejLOper = 42;
			return 40;
//		 case 0: break;
		}
	} else if (rejoRg === 6) {
		switch(rejoRp) {
		 case 1:
			switch(rejoRt) {
			 case 0:{ // Lw: A=A<<<N; ║uz0
					let n = rejaR & 0o77;
					if (n > 38)	rejA = 0;
					else if (n >=8)	rejA = (rejA << (n - 8)) * 256;
					else {	let e = rejA & 255; rejA = ((((rejA-e) / 256) << n) * 256) + (e << n); }
				}
				rejNd = false;
				rejU = rejA < 0;
				rejZ = rejA === 0;
				break;
			 case 1:{ // Pr: A=A>>>N; Ω║uz0
					let n = rejaR & 0o77;
					if (n !== 0) {
						if (rejA < 0) rejA += 0o20000000000000;
						rejA = Math.floor(rejA / (2**n));
						rejOm = rejA & 1;
						rejA = rejA - rejOm;
					}
				}
				rejNd = false;
				rejU = rejA < 0;
				rejZ = rejA === 0;
				break;
			 case 2:{ // Al: A=A<<N; ║uzn
					rejNd = false;
					let n = rejaR & 0o77;
					if (n > 38) {
						if (rejA !== 0) {rejNd = true; rejA = 0;}
					} else {
						let p = 2**(39-n);
						if ((rejA >= p) || (rejA < -p)) rejNd = true;
						if (rejA < 0) rejA += 0o20000000000000;
						rejA = (rejA % (p*2)) * (2**n);
						if (rejA >= 0o10000000000000) rejA -= 0o20000000000000;
					}
				}
				if (rejNd && stopNd) biegCPU = -1;
				rejU = rejA < 0;
				rejZ = rejA === 0;
				break;
			 case 3:{ // Ap: A=A>>N; Ω║uz0
					let n = rejaR & 0o77;
					if (n !== 0) {
						rejA = Math.floor(rejA / (2**n));
						rejOm = rejA & 1;
						rejA = rejA - rejOm;
					}
				}
				rejNd = false;
				rejU = rejA < 0;
				rejZ = rejA === 0;
				break;
			 case 4:{ // Cp: A=A>><N; Ω║uz0
					let n = rejaR & 0o77;
					if (n !== 0) {
						if (n >= 39) n -= 39;
						if (rejA < 0) rejA += 0o20000000000000;
						let p = 2**n,
						    e = rejA % (p * 2);
						rejA = ((rejA - e) / p) + (e * (2**(39-n)));
						if (rejA < 0o10000000000000)	rejOm = 0;
						else { rejA -=0o20000000000000;	rejOm = 1;}
					}
				}
				rejNd = false;
				rejU = rejA < 0;
				rejZ = rejA === 0;
				break;
			 case 5:// AlD: AM=AM<<N; Ω║uzn
				rejNd = false;
				rejU = rejA < 0;
				rejZ = rejA === 0;
				if (rejB[7] < 0) rejB[7] += 0o10000000000000;
				if (rejLOper = rejaR & 0xFF) { // albo 0o77;
					opisEtapu = 'Trwa przesuwanie AM';
					etapCPU = krokCPUdAlD;
					return krokCPUdAlD();
				}
				break;
			 case 6:// ApD: AM=AM>>N; Ω║uz0
				rejNd = false;
				rejU = rejA < 0;
				rejZ = rejA === 0;
				if (rejB[7] < 0) rejB[7] += 0o10000000000000;
				if (rejLOper = rejaR & 0xFF) { // albo 0o77;
					opisEtapu = 'Trwa przesuwanie AM';
					etapCPU = krokCPUdApD;
					return krokCPUdApD();
				}
				break;
			 default:// DzD: A=A//M,N; Ω║uzn/
				etapCPU = krokCPUdDiv;
				opisEtapu = 'Trwa dzielenie stałoprzecinkowe';
				rejNd = false;
				sprawdzDziel(rejB[7]);
				if ((divLOper = rejLOper = (rejaR & 0xFF) - 1) > 0)
					return 40;
			}
			break;
		 case 2:
			switch(rejoRt) {
			 case 0:// We0: A34..=PTR0;║uz.
				aktywneIO = 0;
				etapCPU = czytajPTR;
				return czytajPTR();
			 case 1:// We1: A34..=TTY; ║uz.
				etapCPU = czytajTTY;
				return czytajTTY();
			 case 2:// We2: A34..=PTR2;║uz.
				aktywneIO = 2;
				etapCPU = czytajPTR;
				return czytajPTR();
			 case 3:// CzK:A=klawiszeA;║uz.
				rejA = nastawaA;
				rejU = rejA < 0;
				rejZ = rejA === 0;
				break;
			 case 4:// Okr: A=A+Ω; ║uzn
				rejA += rejOm * 2;
				if ((rejA >= -0o10000000000000) && (rejA < 0o10000000000000))
					rejNd = false;
				else {	rejNd = true;
					if (stopNd) biegCPU = -1;
					let s = rejA & 0o377;
					rejA = (((rejA-s) / 0o400) | 0) * 0o400 + s;
				}
				rejU = rejA < 0;
				rejZ = rejA === 0;
				break;
			 case 5:// Wy5: PTP5=A0_4; ║uz.
				if (urzIO[5].ruch) {
					opisEtapu = 'Znak wyperforowany';
					etapCPU = null;
					return piszPTP(5);
				}
				break;
			 case 6:// Wy6: TTY=A0_4; ║uz.
				opisEtapu = 'Znak wypisany';
				etapCPU = null;
				return piszTTY();
			 default:// Stop;
				biegCPU = -1;
			}
			break;
		 case 3:
			if ((rejoRt <= 4) && rejoRt) {	// BF1, BF2, FB1, FB2
				if (modelODRA >= 2) {
					blk1od = blk2od = rejaR & 0o177;
					blk1do = blk2do = blk1od + (rejLOper = (rejB[rejmR] >>> 18) & 0o177);
					if (blk2do > 127) {blk2do -= 128; blk2od = 0; blk1do = 127;}
					blkf = (((rejoRt === 1) || (rejoRt === 3)) ? 0o20000 : 0o20200);
					blkb = rejaR & 0o17600;
					if (rejoRt > 2)	{ let a = blkf; blkf = blkb; blkb = a; }
					opisEtapu = 'Trwa kopiowanie blokowe';
					etapCPU = krokCPUdBF;
					return krokCPUdBF();
				}
				wymaganaODRA1013();
			} // else rejoRt = 0, 5, 6, 7
			break;
		 case 4:
			switch(rejoRt) {
			 case 0:// SkZ: goto 0Zn? N: K;
				if (rejZ) rejnR = rejaR;
				break;
			 case 1:// SkU: goto U0n? N: K;
				if (rejU) rejnR = rejaR;
				break;
			 case 2:// SkD: goto 00n? N: K;
				if ((!rejZ) && (!rejU)) rejnR = rejaR;
				break;
			 case 3:// SkNd:goto uzN? N: K;
				if (rejNd) rejnR = rejaR;
				break;
			 case 4:// SkBG: goto BG? N: K;
				if (modelODRA & 1)
					wymaganaODRAUMCS();
				else {
					let u = rejmR;
					if ((((u === 0) || (u === 2)) && ((urzIO[u].ruch !== 1) || (urzIO[u].pozDanych >= urzIO[u].dane.length))) ||
					    ((u === 1) && (urzIO[11].ruch === 0) &&
					     ((urzIO[1].ruch !== 1) || (urzIO[1].pozDanych >= urzIO[1].dane.length)) &&
					     ((urzIO[10].ruch!== 1) || ((urzIO[10].pozDanych >= urzIO[10].dane.length) && (TTY.kodyWej === 0)))))
						rejnR = rejaR;
				}
				break;
			 case 5:{ // KC-:SkLC: goto B--? N: K;
					let n = rejB[rejmR] & 0o17777000000;
					if (n) rejnR = rejaR;
					if (rejmR) rejB[rejmR] += ((n-0o1000000) & 0o17777000000) - n;
				}
				break;
			 case 6:{ // KC+:SkLC: goto B++? N: K;
					let n = rejB[rejmR] & 0o17777000000;
					if (n) rejnR = rejaR;
					if (rejmR) rejB[rejmR] += ((n+0o1000000) & 0o17777000000) - n;
				}
				break;
			 default:// SkS:n=0NKB0;goto N+2;
				rejnR = (rejaR + 2) & 0o17777;
				if (blokadaPam(rejaRw) === 0) {
					pamOper[rejaRw] = rejR & 0o17777777774;
//					if (widocznaPAM & 1) {
						ctxPAM.fillStyle = kolTypuPAM[pamTyp[aRwAArgPAM]];
						ctxPAM.fillRect((aRpAArgPAM&127)*5+1, (aRpAArgPAM>>>7)*4, 4, 3);
						let aRw = aRwAArgPAM = rejaRw,
						    aRp = aRpAArgPAM = rejaRp;
						ctxPAM.fillStyle = kolAktyPAM[pamTyp[aRw] = 4];
						ctxPAM.fillRect((aRp&127)*5+1, (aRp>>>7)*4, 4, 3);
						if (ustalonyAdr === aRw) zapalDymPam();
//					}
				}
			}
			break;
		 case 6:
			switch(rejoRt) {
			 case 0:// XWe0: A31..=PTR0';║uz.
				if (modelODRA & 1) {
					aktywneIO = 3;
					etapCPU = czytajPTR;
					return czytajPTR();
				}
				wymaganaODRAUMCS();
				break;
			 case 2:// XWe2: A31..=PTR2';║uz.
				if (modelODRA & 1) {
					aktywneIO = 4;
					etapCPU = czytajPTR;
					return czytajPTR();
				}
				wymaganaODRAUMCS();
				break;
			 case 5:// XWy5: PTP5'=A0_7; ║uz.
				if (modelODRA & 1) {
					opisEtapu = 'Znak wyprowadzony';
					let t = 40;
					if (urzIO[7].ruch) t = piszPTP(7);
					if (urzIO[8].ruch) t = piszMAW();
					etapCPU = null;
					return t;
				}
				wymaganaODRAUMCS();
//				break;
//			 case 1, 3, 4, 6, 7:	break;
			}
//			break;
//		 case 0, 5, 7:	break;
		}
	} else { // (rejoRg === 7) - zmienny przecinek
		if (rejoRt === 2) { // X=AC,BON; ║uz.0
			rejU = rejA < 0;
			rejZ = rejA === 0;
			let x = (rejA - (rejA & 255)) + (rejAc & 127) * 2;
			rejs = x;
			if (rejoRp < 4) {
				if (blokadaPam(rejaRw) === 0) {
					pamOper[rejaRw] = x;
//					if (widocznaPAM & 1) {
						ctxPAM.fillStyle = kolTypuPAM[pamTyp[aRwAArgPAM]];
						ctxPAM.fillRect((aRpAArgPAM&127)*5+1, (aRpAArgPAM>>>7)*4, 4, 3);
						let aRw = aRwAArgPAM = rejaRw,
						    aRp = aRpAArgPAM = rejaRp;
						ctxPAM.fillStyle = kolAktyPAM[pamTyp[aRw] = 2];
						ctxPAM.fillRect((aRp&127)*5+1, (aRp>>>7)*4, 4, 3);
						if (ustalonyAdr === aRw) zapalDymPam();
//					}
				}
			} else {
				if (rejmR ===7)	rejB[7] = x;
				else if (rejmR)	rejB[rejmR] = x & 0o17777000000;
			}
		} else if (rejoRt) {
			let xc = rejx & 255,
			    xm = rejx - xc;
			xc = (xc << 24) >> 25;
			if (rejoRt === 1) { // AC=X,BON; ║uz.0
				if (xm === 0) xc = -64;
				else if (rejoRp & 1) { // normalizacja
					while ((xm < 0o4000000000000) && (xm >= -0o4000000000000)) {
						xm *= 2; xc--;
					}
					if (xc < -64) {xm = 0; xc = -64;}
				}
				rejA = xm;
				rejAc= xc;
				rejU = rejA < 0;
				rejZ = rejA === 0;
			} else if (rejoRt < 6) { 	// AC=AC+X,BON; ║uz.*	// AC=AC-X,BON; ║uz.*
				etapCPU = krokCPUdDOz;				// AC=X-AC,BON; ║uz.*
				opisEtapu = (rejoRt === 3 ? 'Trwa dodawanie zmiennoprzecinkowe' : 'Trwa odejmowanie zmiennoprzecinkowe');
				rejxm = xm;
				rejxc = xc;
				let c = rejAc;
				if (c < xc) c = xc;
				rejs = (c + 1) * 2;
				rejLOper = 3;
				return 40;
			} else if (rejoRt === 6) { // AC=AC*X,BON; M=#║uz.*
				etapCPU = krokCPUdMuz;
				opisEtapu = 'Trwa mnożenie zmiennoprzecinkowe';
				rejxm = xm;
				rejs = (rejAc + xc + 1) * 2;
				rejLOper = 38;
				return 40;
			} else { // (rejoRt === 7) { // AC=AC/X,BON; M=#║uz/*
				etapCPU = krokCPUdDiz;
				opisEtapu = 'Trwa dzielenie zmiennoprzecinkowe';
				rejs = (rejAc - xc + 1) * 2;
				sprawdzDziel((rejB[7] = xm) * 2);
				rejLOper = 44;
				return 40;
			}
		}
		//T=0 - nic nie rób
	}
	etapCPU = null;
	return 40;
}

function krokCPUdDiz() { // (d) Dzielenie zmiennoprzecinkowe
	let l = rejLOper;
	if (rejNd) {
		if (kwantBiegu > 1)	rejLOper = 0;
		else			rejLOper--;
	} else if (--rejLOper === 43) {
		rejAc = rejs / 2;
		if	(rejAc < -64) {rejA = 0; rejAc = -64;}
		else if	(rejAc > 63) {rejNZ = true; biegCPU = -1; rejAc = (rejAc << 25) >> 25;}
	} else if (rejLOper === 42) {
		divM0 = (divM = rejB[7]) < 0;
		if (((rejR = rejA / 2) < 0) === divM0)	rejOm = 1;
		else					rejOm = 0;
		rejA = 0;
	} else if (rejLOper > 1) {
		if (rejR) {
			if (rejOm) rejR -= divM;
			else	   rejR += divM;
			let e = rejR & 255;
			rejR = (((rejR - e) / 256) | 0) * 256 + e;
			if (((rejR<0) === divM0) || (rejR===0))	rejOm = 1;
			else					rejOm = 0;
			e = (rejR *= 2) & 255;
			rejR = (((rejR - e) / 256) | 0) * 256 + e;
		} else
			rejOm = 0;
		let e = (rejA = rejA * 2 + rejOm) & 255;
		rejA = (((rejA - e) / 256) | 0) * 256 + e;
	} else if (rejLOper) {
		rejA -= rejOm;
		let m = rejA, c = rejAc;
		if (m === 0) rejAc = -64;
		else {
			if (rejoRp & 1) { // normalizacja
				while ((m < 0o4000000000000) && (m >= -0o4000000000000)) {
					m *= 2; c--;
				}
			}
			if (c < -64) {m = 0; c = -64;}
			if (rejoRp & 2) { // zaokrąglenie logiczne
				let e = m & 511;
				m += ((e & 256) | ((e & 128) * 2)) - e;
			}			
			rejA = m;
			rejAc= c;
			}
	} else {
		rejU = rejA < 0;
		rejZ = rejA === 0;
	}
	if (rejLOper === 0) {
		opisEtapu = (rejNd ? 'Dzielenie niewykonane' : 'Dzielenie zmiennoprzecinkowe wykonane');
		etapCPU = null;
	}
	return (l - rejLOper) * 40;
}

function krokCPUdMuz() { // (d) Mnożenie zmiennoprzecinkowe
	let l = rejLOper,
	    o = l & 1;
	if (l > 36) {
		if (!o) {
			rejAc = rejs / 2;
			if	(rejAc < -64) {rejA = 0; rejAc = -64;}
			else if	(rejAc > 63) {rejNZ = true; biegCPU = -1; rejAc = (rejAc << 25) >> 25;}
			rejxm /= 256;
			if (rejxm < 0) rejxm += 0o100000000000;
			rejB[7] = rejxm;
			rejR = rejA / 2;
			rejLOper--;
		}
		if (o || kwantBiegu) {
			rejA = 0;
			rejLOper--;
		}
	} else if (l > 4) {
		let rejM = rejB[7],
		    h = 1;
		if ((!o) && kwantBiegu)	h++;
		rejLOper -= h;
		do {
			let m = rejM & 1;
			rejM = (rejM - m) / 2;
			rejs = rejA += (rejx = (m ? rejR : 0));
			if (rejA & 1) {	rejOm = 1; rejA--; rejM += 0o4000000000000;}
			else		rejOm = 0;
			rejA /= 2;
		} while (--h);
		rejB[7] = rejM;
	} else if (l > 2) {
		if (!o) {
			let m = rejB[7] & 1;
			rejB[7] -= m;
			rejs = rejA -= (rejx = (m ? rejR : 0));
			rejLOper--;
		}
		if (o || kwantBiegu) {
//			rejR -= rejR & 1;
			rejA *= 2;
			rejLOper--;
		}
	} else {
		if (!o) {
			let m = rejA, c = rejAc;
			if (m === 0) rejAc = -64;
			else {
				if (rejoRp & 1) { // normalizacja
					while ((m < 0o4000000000000) && (m >= -0o4000000000000)) {
						m *= 2; c--;
					}
				}
				if (c < -64) {m = 0; c = -64;}
				if (rejoRp & 2) { // zaokrąglenie logiczne
					let e = m & 511;
					m += ((e & 256) | ((e & 128) * 2)) - e;
				}			
				rejA = m - (m & 1);
				rejAc= c;
			}
			rejLOper--;
		}
		if (o || kwantBiegu) {
			rejU = rejA < 0;
			rejZ = rejA === 0;
			rejLOper--;
		}
	}
	if (rejLOper === 0) {
		opisEtapu = 'Mnożenie zmiennoprzecinkowe wykonane';
		etapCPU = null;
	}
	return (l - rejLOper) * 20;
}

function krokCPUdDOz() { // (d) Dodawanie zmiennoprzecinkowe
	if (rejLOper === 3) {
		let c = rejs / 2;
		rejA = Math.floor(rejA / (2 ** (c-rejAc)));
		rejx = Math.floor(rejxm/ (2 ** (c-rejxc)));
		if ((rejAc = c) > 63) {rejNZ = true; biegCPU = -1;}
	} else if (rejLOper === 2) {
		switch(rejoRt) {
		 case 3: rejs = rejA + rejx;	break;
		 case 4: rejs = rejA - rejx;	break;
		 default:rejs = rejx - rejA;
		}
	} else {let m = rejs, c = rejAc;
		if (m === 0) {rejA = 0; rejAc = -64;}
		else {
			if (rejoRp & 1) { // normalizacja
				while ((m < 0o4000000000000) && (m >= -0o4000000000000)) {
					m *= 2; c--;
				}
				if (c < -64) {m = 0; c = -64;}
			}
			if (rejoRp & 2) { // zaokrąglenie logiczne
				let e = m & 511;
				m += ((e & 256) | ((e & 128) * 2)) - e;
			}			
			rejA = m - (m & 1);
			rejAc= (c << 25) >> 25;
		}
		rejU = rejA < 0;
		rejZ = rejA === 0;
	}
	if ((--rejLOper) === 0) {
		opisEtapu = (rejoRt === 3 ? 'Dodawanie zmiennoprzecinkowe wykonane' : 'Odejmowanie zmiennoprzecinkowe wykonane');
		etapCPU = null;
	}
	return 40;
}

function krokCPUdMul() { // (d) Mnożenie stałoprzecinkowe
	let l = rejLOper,
	    o = l & 1;
	if (rejNd) {
		if (kwantBiegu > 1)	rejLOper = 0;
		else 			rejLOper -= 2;
	} else if (l > 40) {
		if (!o) {
			rejB[7] /= 2;
			if (rejB[7] < 0) rejB[7] += 0o10000000000000;
			rejR = rejA / 2;
			rejLOper--;
		}
		if (o || kwantBiegu) {
			rejA = 0;
			rejLOper--;
		}
	} else if (l > 2) {
		let rejM = rejB[7],
		    h = 1;
		if ((!o) && kwantBiegu)	h++;
		rejLOper -= h;
		do {
			let m = rejM & 1;
			rejM = (rejM - m) / 2;
			rejs = rejA += (rejx = (m ? rejR : 0));
			if (rejA & 1) {	rejOm = 1; rejA--; rejM += 0o4000000000000;}
			else		rejOm = 0;
			rejA /= 2;
		} while (--h);
		rejB[7] = rejM;
	} else {
		if (!o) {
			let m = rejB[7] & 1;
			rejB[7] -= m;
			rejs = rejA -= (rejx = (m ? rejR : 0));
			rejLOper--;
		}
		if (o || kwantBiegu) {
//			rejR -= rejR & 1;
			rejA *= 2;
			if (rejA === 0o10000000000000) {
				rejNd = true;
				if (stopNd) biegCPU = -1;
				rejA -= 0o20000000000000;
			}
			rejU = rejA < 0;
			rejZ = (rejA === 0) && (rejB[7] === 0);
			rejLOper--;
		}
	}
	if (rejLOper === 0) {
		opisEtapu = 'Mnożenie stałoprzecinkowe wykonane';
		etapCPU = null;
	}
	return (l - rejLOper) * 20;
}

function krokCPUdDiv() { // (d) Dzielenie stałoprzecinkowe
	let l = rejLOper;
	if (rejNd) {
		if (kwantBiegu > 1)	rejLOper = 0;
		else			rejLOper--;
	} else if (rejLOper-- === divLOper) {
		divM0 = (divM = rejB[7]) < 0;
		if (((rejR = rejA) < 0) === divM0)	rejOm = 1;
		else					rejOm = 0;
		rejA = 0;
	} else if (rejLOper) {
		if (rejR) {
			if (rejOm) rejR -= divM;
			else	   rejR += divM;
			let e = rejR & 255;
			rejR = (((rejR - e) / 256) | 0) * 256 + e;
			if (((rejR<0) === divM0) || (rejR===0))	rejOm = 1;
			else					rejOm = 0;
			e = (rejR *= 2) & 255;
			rejR = (((rejR - e) / 256) | 0) * 256 + e;
		} else
			rejOm = 0;
		let e = (rejA = rejA * 2 + rejOm) & 255;
		rejA = (((rejA - e) / 256) | 0) * 256 + e;
	} else {
		rejA -= rejOm;
		rejU = rejA < 0;
		rejZ = rejA === 0;
	}
	if (rejLOper === 0) {
		opisEtapu = (rejNd ? 'Dzielenie niewykonane' : 'Dzielenie stałoprzecinkowe wykonane');
		etapCPU = null;
	}
	return (l - rejLOper) * 40;
}

function krokCPUdBF() { // (d) Przesyłanie blokowe
 function BF() {
	if (blokadaPam(blkf) === 0) {
		let f = blkf + s,
		    v = f,
		    b = blkb + s;
		pamOper[f] = pamOper[b];
//		if (widocznaPAM & 1) {
			ctxPAM.fillStyle = kolTypuPAM[pamTyp[aRwAArgPAM]];
			ctxPAM.fillRect((aRpAArgPAM&127)*5+1, (aRpAArgPAM>>>7)*4, 4, 3);
			let t = pamTyp[f] = pamTyp[b];
			if ((f < 0o17200) || (f >= 0o17600)) {
				if (f >= 0o20000) v -= 0o600;
				aRwAArgPAM = f;
				aRpAArgPAM = v;
				ctxPAM.fillStyle = kolAktyPAM[t];
				ctxPAM.fillRect((v&127)*5+1, (v>>>7)*4, 4, 3);
				if (ustalonyAdr === f) zapalDymPam();
			}
//		}
	}
	rejLOper--;
 }
	let s = strefaB;
	if (adresacja === 1)
		BF();
	else {
		let p = strefyP[s];
		if (kwantBiegu > 1) {
			while (((p < blk1od) || (p > blk1do)) && ((p < blk2od) || (p > blk2do)))
				p = strefyP[s = (s + 1) & 0o177];
		}
		if ((p >= blk1od) && (p <= blk1do) || (p >= blk2od) && (p <= blk2do))
			BF();
	}
	let k = ((s + 1) & 0o177) - strefaB;
	if (k <= 0) k += 128;
	if (rejLOper < 0) {
		opisEtapu = 'Kopiowanie wykonane';
		etapCPU = null;
	}
	return k * 40;
}

function krokCPUdAlD() { // (d) Przesuwanie AM w lewo
	rejB[7] *= 2;
	let Ω = 0;
	if (rejB[7]>=0o10000000000000) {Ω = 1; rejB[7] -= 0o10000000000000;}
	rejOm = rejB[7] >= 0o4000000000000;
	rejA = (rejA + Ω) * 2;
	if ((rejA < -0o10000000000000) || (rejA >= 0o10000000000000)) {
		rejNd = true;
		if (stopNd) biegCPU = -1;
		let a = rejA & 0o377;
		rejA = (((rejA-a) / 0o400) | 0) * 0o400 + a;
	}
	rejU = rejA < 0;
	rejZ = rejA === 0;
	if ((--rejLOper) === 0) {
		opisEtapu = 'Przesunięcie wykonane';
		etapCPU = null;
	}
	return 40;
}

function krokCPUdApD() { // (d) Przesuwanie AM w prawo
	rejA /= 2;
	rejA -= (rejOm = rejA & 1);
	let m = rejB[7];
	rejB[7] = (m - (m & 3)) / 2 + rejOm * 0o4000000000000;
	rejU = rejA < 0;
	rejZ = rejA === 0;
	if ((--rejLOper) === 0) {
		opisEtapu = 'Przesunięcie wykonane';
		etapCPU = null;
	}
	return 40;
}

function fTypTTY() { // Zmiana typu dalekopisu
 if (!zasilB) {
	let tty = TTY;
	if (++tty.typ >= typyTTY.length) tty.typ = 0;
	if (typeof(Storage) !== 'undefined') localStorage.setItem("modelTTY", tty.typ);
	let h = document.getElementById("TTYt"),
	    t = typyTTY[tty.typ];
	h.textContent = 'TTY ' + t.nazwa;
	h.title = 'Sterowanie dalekopisu:\n' + t.sterownia.opis;
	tty.krosownia= t.sterownia.kros;
	tty.jezykP   = t.jezykP;
	tty.alfabet  = t.alfabet;
	tty.alfabetU = '';
	let l = tty.alfabet.length;
	for (let i=0; i < l; i+=32)
		tty.alfabetU +=	'\uFFFF' + t.alfabet.charAt(i+1) + '\u000A' + t.alfabet.charAt(i+3) + ' ' + t.alfabet.substring(i+5,i+8) + '\u000D' + t.alfabet.substring(i+9,i+27) + '\uFFFF' + t.alfabet.substring(i+28,i+31) + '\uFFFF';
	urzIO[9].guzv.textContent = tty.daneMon = ' '.repeat(Math.floor(urzIO[9].guzv.clientWidth * 50 / fontWidth50));
	urzIO[10].guzv.textContent = 'Θανάσης';	tty.daneTXT = '       ';
	for (let i=12; i--;) oknoCpuPre[i] = 0.5;
	tty.kodyWej = 0;
	tty.trybKlaw= 0x20;
	tty.stanShC = 0x00;
	tty.stanAlt = 0x40;
	tty.stanMon = 0x20;	ustawKlawisze();
	tty.stanMon = 0x00;	ustawKlawisze();
	tty.kla[66].style.boxShadow = tty.kla[67].style.boxShadow = '';
	pamOper[0o17664] = pamOper[0o17654] += (tty.jezykP << 18) - (pamOper[0o17654] & 0o77000000);
	zapalRejestry();
	zapalDymPam();
 }
}

function ustawKlawisze() { // Ustawienie klawiatury wg stanu dalekopisu
	let tty = TTY,
	    kl = tty.kla,
	    p = tty.stanMon & 0x60,	//pp00000
	    f = p & 0x20;		//0p00000
	if (f) {//cyfry/spec
		if ((p === 0x20) !== (tty.stanAlt === 0x00)) {
			for (let i=32; i--;) if (i !== 4) kl[i+32].textContent = tty.alfabet.charAt(p+i);
			kl[68].style.boxShadow = kl[69].style.boxShadow = (p === 0x20) ? '' : klaWcisniety;
			tty.stanAlt = 0x40 - tty.stanAlt;
		}
	} else {//wielkie/małe
		if ((p === 0x40) !== (tty.stanShC === 0x00)) {
			for (let i=32; i--;) if (i !== 4) kl[i].textContent = tty.alfabet.charAt(p+i);
		}
		let h = p ? 0x00 : (((tty.stanMon & 0x1F) < 3) ? 0x60 : 0x40);
		if ((h === 0x60) !== (tty.stanShC === 0x60)) kl[64].style.boxShadow = (h === 0x60) ? klaWcisniety : '';
		if ((h === 0x40) !== (tty.stanShC === 0x40)) kl[66].style.boxShadow = kl[67].style.boxShadow = (h === 0x40) ? klaWcisniety : '';
		tty.stanShC = h;
	}
	if ((tty.trybKlaw !== 0x40) && (tty.trybKlaw !== f)) {
		for (let i=32, d=32-f; --i;) {
			if ([2, 4, 8, 27, 31 /*LF,SP,CR,FS,LS*/].indexOf(i) < 0) {
				kl[i+d].disabled = true;
				kl[i+f].disabled = false;
			}
		}
		tty.trybKlaw = 0x20 - tty.trybKlaw;
	}
}

function fUt(btn,u) { // Klawisz T czytnika
 if (urzIO[u].ruch !== 1)
	btn.click();
}

function fUn(u) { // Klawisz Ø urządzenia
 let urz = urzIO[u];
 if (urz.ruch !== 1) {
	urz.dane = (u > 8) ? '' : noFILE;
	urz.prePozDanych = urz.pozDanych = 0;
	let o = urz.okno;
	o.textContent = '';
	o.style.height = (urz.wysOkna = fontHeight + (u >= 9 ? scrollbarHeight : 0)) + 'px';
	o.style.display = '';
	o.removeAttribute('title');
	urz.guzv.setAttribute ('class', 'vIO');
 }
}

function fDajT(input, u) { // Założenie tasiemki do czytnika
 let urz = urzIO[u];
 if (urz.ruch !== 1) {
	let file = input.files[0],
	    filename = file.name;
	if (file) {
		const reader = new FileReader();
		reader.onload = function(e) {
			urz.dane = new Uint8Array(e.target.result);
			let d = urz.dane,
			    o = urz.okno,
			    l = d.length,
			    s = urz.szer,
			    t = '';
			urz.prePozDanych = urz.pozDanych = 0;
			for (let i=0; i<l; i++) {
				let c = d[i],
				    r = '';
				for (let j=s; j--; c <<= 1) r += (c & 128 ? '●' : ' ');
				t += r.substring(0,3) + '•' + r.substring(3) + '\n';
			}
			o.textContent = t;
			o.setSelectionRange(0, s + 2);
			o.style.height = (urz.wysOkna = (l+1) * pfontHeight) + 'px';
			o.style.display = 'block';
			o.scrollTop = 0;
			o.title = filename;
			o.focus();
			urz.guzv.setAttribute ('class', (l ? 'vIO cIO'+u : 'vIO'));
		};
		reader.readAsArrayBuffer(file);
		input.value = '';
	}
 }
}

function fDajX(input) { // Założenie tekstu klawiatury
 let urz = urzIO[10];
 if (urz.ruch !== 1) {
	let file = input.files[0],
	    filename = file.name;
	if (file) {
		const reader = new FileReader();
		reader.onload = function(e) {
			urz.dane = e.target.result;
			urz.prePozDanych = urz.pozDanych = 0;
			let o = urz.okno;
			o.textContent = e.target.result.replace(/\r/g, " ");
			o.style.height = (urz.wysOkna = 12 * fontHeight + scrollbarHeight) + 'px';
			o.style.display = 'block';
			o.setSelectionRange(0, 1);
			o.scrollTop = 0;
			o.title = filename;
			o.focus();
			urz.guzv.setAttribute ('class', (e.target.result.length ? 'vIO cIO10' : 'vIO'));
		};
		reader.readAsText(file, 'utf-8');
		input.value = '';
	}
 }
}

function fPodg(u) { // Podgląd tasiemki, wydruku
	let os = urzIO[u].okno.style;
	os.display = (os.display === '' ? 'block' : '');
}

function czytajPTR() { // Czytanie kodu z czytnika
	let urz = urzIO[aktywneIO];
	switch(urz.ruch) {
	 case 1: // biega
		let d = urz.dane;
		if (urz.pozDanych < d.length) {
			let c = d[urz.pozDanych++],
			    z = 512;
			if (urz.szer === 5) {z = 64; c >>>= 3;}
			rejA = Math.floor(rejA / z) * z + c * 2;
			rejU = rejA < 0;
			rejZ = rejA === 0;
			opisEtapu = 'Znak wczytany';
			etapCPU = null;
			break;
		}
	 case 0: // zatrzymane
		urz.ruch = 2;
		urz.lamp.setAttribute ('class','lIO lam2');
	 default:// czeka
		nowyCykl = 5;
		opisEtapu = 'Czekanie na urządzenie';
	}
	return 240; // 1066 zn/s
}

function czytajTXT() { // Czytanie kodu z klawiatury/tekstu Dalekopisu
	let urz = urzIO[aktywneIO]; //10,11
	switch(urz.ruch) {
	 case 1:{ // biega
		let tty = TTY;
		if (tty.kodyWej === 0) {
			if (urz.pozDanych < urz.dane.length) { // Zamiana znaku TXT na kody ITA
				let z = urz.dane.charAt(urz.pozDanych++);
				if (z === '\u0009') {
					z = ' ';
					if ((tty.pozKaretki & 7) !== 7) {urz.pozDanych--; }//urz.prePozDanych = -1;}
				}
				let i = tty.alfabetU.indexOf(z);
				if (i < 0) {
					let x = z.toUpperCase();
					if (x === z) x = z.toLowerCase();
					if (x !== z) i = tty.alfabetU.indexOf(x);
					if (i < 0) i = 4;
				}
				if (aktywneIO === 10)
					tty.daneTXT = tty.daneTXT.substr(1) + tty.alfabet.charAt(i);
				let c = (i & 31) + 32,
				    p = (i >>> 5) + 5,
				    s = tty.stanMon & 0x1F,
				    w = 0;
				if ((i !== 4) && (i !== 2) && (i !== 8)) { //nie SP,LF,CR
					if (aktywneIO === 10) {	//TXT - symulacja klawisza CAPS
						if (p === 5) {
							if ((urz.caps === 0) && ((urz.pozDanych + 1) < urz.dane.length)) {
								let z2	= urz.dane.charAt(urz.pozDanych),
								    i2	= tty.alfabetU.indexOf(z2);
								if (i2 < 0) {
									let x2 = z2.toUpperCase();
									if (x2 === z2) x2 = z2.toLowerCase();
									if (x2 !== z2) i2 = tty.alfabetU.indexOf(x2);
									if (i2 < 0) i2 = 4;
								}
								if ((i2 < 32) && (i2 !== 4) && (i2 !== 2) && (i2 !== 8)) {
									z2 = urz.dane.charAt(urz.pozDanych + 1);
									i2 = tty.alfabetU.indexOf(z2);
									if (i2 < 0) {
										let x2 = z2.toUpperCase();
										if (x2 === z2) x2 = z2.toLowerCase();
										if (x2 !== z2) i2 = tty.alfabetU.indexOf(x2);
										if (i2 < 0) i2 = 4;
									}
									if ((i2 < 32) && (i2 !== 4) && (i2 !== 2) && (i2 !== 8)) urz.caps = 1;
								}
							}
						} else if (p > 6)
							urz.caps = 0;
					}
					if (p === 5) p -= urz.caps;
					w = tty.krosownia[s][p];
				}
				for (let j=1; j<=w; j<<=6, c<<=6) ;
				tty.kodyWej = c + w;
			}
		}
		if (tty.kodyWej) {
			rejA = Math.floor(rejA / 64) * 64 + (tty.kodyWej & 0o37) * 2;
			rejU = rejA < 0;
			rejZ = rejA === 0;
			tty.kodyWej >>>= 6;
			opisEtapu = 'Znak wczytany';
			etapCPU = null;
			break;
		}
		}
	 case 0: // zatrzymane
		urz.ruch = 2;
		urz.lamp.setAttribute ('class','lIO lam2');
	 default:// czeka
		nowyCykl = 5;
		opisEtapu = 'Czekanie na urządzenie';
	}
	return 32000; // 8 zn/s
}

function eventKlaw(event) { // klawisz Hosta
 let urz = urzIO[11];
 if (urz.ruch === 2) {
	let k = event.key;
	urz.caps = event.getModifierState("CapsLock") ? 1 : 0;
	if (k.length === 1) {
		let i = TTY.alfabetU.indexOf(k);
		if (i < 0) {
			let x = k.toUpperCase();
			if (x === k) x = k.toLowerCase();
			if (x !== k) i = TTY.alfabetU.indexOf(x);
			if (i < 0) return;
		}
	} else {
		if	(k === 'Tab')	k = '\u0009';
		else if	(k === 'Enter') k = '\u000D\u000A';
		else return;
	}
	urz.dane = k;
	urz.pozDanych = 0;
	urz.ruch = 1;
	urz.lamp.setAttribute ('class','lIO lam1');
	setTimeout(petlaCPU);
 }
}

function czytajTTY() { // Czytanie z dalekopisu
	let /* klawiatura */	 u = 11,f = czytajTXT;
	if	(urzIO[1].ruch) {u = 1; f = czytajPTR;}
	else if	(urzIO[10].ruch) u = 10;// plik tekstowy
	else			 urzIO[11].guzv.focus();
	aktywneIO = u;
	let t = f();
	if (etapCPU === null) {
		let a = rejA;
		rejA = (rejA & 0o76) * 0o200000000000;
		t += piszTTY();
		rejA = a;
	}
	return t;
}

function piszTTY() { // pisanie na dalekopis
	let c = Math.floor(rejA / 0o400000000000) & 31,
	    tty = TTY,
	    s = tty.stanMon,
	    pc = (s & 0x60) + c,
	    t = 40,
	    i = 0;
	switch(c) {
	 case 31:/*LS*/	i = 1;	break;
	 case 27:/*FS*/ i = 2;	break;
	 case  0:/*NU*/ i = 3;	break;
	 case 2: /*LF*/
	 case 8: /*CR*/ tty.pozKaretki = 0; break;
	 default:/*in*/ tty.pozKaretki++;
	}
	tty.stanMon = tty.krosownia[s & 0x1F][i];
	tty.daneMon = tty.daneMon.substr(1) + tty.alfabet.charAt(pc);
	tty.zmianaMon = true;
	if (urzIO[6].ruch)
		t = piszPTP(6);
	let urz9 = urzIO[9];
	if (urz9.ruch) {
		switch(c) {
		 case 2: /*LF*/
			if (urz9.dane.length === 0) urz9.guzv.setAttribute ('class', 'wIO cIO9');
			urz9.dane += CRLFalboLF;
			urz9.wysOkna += fontHeight;
			break;
		 case 31:/*LS*/
		 case 27:/*FS*/
		 case 8: /*CR*/
		 case 0: /*NU*/
			break;
		 default:/*in*/
			if (urz9.dane.length === 0) urz9.guzv.setAttribute ('class', 'wIO cIO9');
			urz9.dane += tty.alfabetU.charAt(pc);
		}
		t = 16000; // 16 zn/s
	}
	return t;
}

function piszPTP(u) { // perforowanie tasiemki
	let c = Math.floor(rejA / 0o40000000000) & 255,
	    urz = urzIO[u],
	    s = urz.szer,
	    l = urz.dane.length,
	    p = urz.pozDanych++,
	    r = '';
	for (let j=s; j--; c <<= 1) r += (c & 128 ? '●' : ' ');
	c >>>= 8;
	if (p === 0) urz.guzv.setAttribute ('class', 'vIO cIO'+u);
	urz.obraz += r.substring(0,3) + '•' + r.substring(3) + '\n';
	urz.wysOkna += pfontHeight;
	if (s === 5) c <<= 3;
	if (p >= l) {
		let nd = new Uint8Array(l+65536);
		nd.set(urz.dane);
		urz.dane = nd;
	}
	urz.dane[p] = c;
	return 1600;	// 160 zn/s
}

function piszMAW() { // rysowanie wykresu
	let c = Math.floor(rejA / 0o40000000000) & 255,
	    urz = urzIO[8],
	    p = urz.poczLinii;
	urz.dane[p + (c >>> 3)] |= 128 >>> (c & 7);
	urz.daneGUZ = urz.daneGUZ.substr(1) + urz.daneGUZ.charAt(0);
	urz.preKonDanych = 0;
	if (urz.konDanych === p) {
		urz.konDanych += 32;
		if (p === 0) urz.guzv.setAttribute ('class', 'vIO cIO8');
	}
	if ((c === 255) || (urz.szer === 256)) {
		p = urz.poczLinii += 32;
		let l = urz.dane.length;
		if (p >= l) {
			let nd = new Uint8Array(l+65536);
			nd.set(urz.dane);
			urz.dane = nd;
		}
		urz.dane.fill(0, p, p+32);
	}
	return 8000;	// 32 pkt/s
}

function fPoz(u) { // Pozycjonowanie tasiemki/tekstu
	let urz = urzIO[u],
	    o = urz.okno,
	    w = (u === 10 ? 1 : urz.szer + 2);
	if (urz.ruch !== 1) // nie biega
		urz.prePozDanych = urz.pozDanych = Math.floor(o.selectionStart / w);
	let p = urz.pozDanych;
	if (u !== 10) o.scrollTop = (p-1) * pfontHeight;
	o.setSelectionRange(p *= w, p + w);
}

function fUs(u) { // Start/Stop czytnika
 let urz = urzIO[u],
     o = urz.okno;
 if (zasilB) {
	let b = urz.ruch;
	if (b === 1) { // biega
		urz.ruch = 0;
		urz.lamp.setAttribute ('class','lIO lam0');
	} else { // zatrzymane lub czeka
		let w = urz.szer + 2,
		    p = urz.pozDanych;
		if (p < urz.dane.length) {
			urz.ruch = 1;
			urz.lamp.setAttribute ('class','lIO lam1');
			if (b) /*czeka*/ setTimeout(petlaCPU);
		}
		o.scrollTop = (p-1) * pfontHeight;
		o.setSelectionRange(p *= w, p + w);
	}
 }
 o.focus();
}

function fUo(u) { // Start/Stop TTW, MAW, perforatora
 let urz = urzIO[u];
 if (zasilB)
	urz.lamp.setAttribute ('class', 'lIO lam' + (urz.ruch = 1 - urz.ruch));
 urz.okno.focus();
}

function fUa() { // AutoWysuw MAW
 if (zasilB) {
	let urz = urzIO[8];
	urz.guza.style.boxShadow = ((urz.img.width = BMPheader[4] = urz.szer = 511 - urz.szer) === 256 ? guzWcisniety : '');
	urz.preKonDanych = 0;
	zapalRejestry();
 }
}

function fUb(u) { // Wypuszczenie NU
 if (urzIO[u].ruch) {
	let a = rejA;
	rejA = 0;
	piszPTP(u);
	rejA = a;
	zapalRejestry();
 }
}

function fUuR() { // Oderwanie rysunku
 let urz = urzIO[8];
 if (urz.konDanych) {
	let dt = new Date();		dt.setTime( dt.valueOf() - dt.getTimezoneOffset() * 60000 );
	let d = dt.toISOString(),	//2021-06-22T20:17:44.795Z
	    f = 'ODRA_' + d.substr(0,4) + d.substr(5,2) + d.substr(8,2) + '_' + d.substr(11,2) + d.substr(14,2) + d.substr(17,2) + '.bmp';
	let filename = prompt("Nazwa składowanego rysunku", f);
	if (filename !== null) {
		if (filename === '') filename = f;
		let a = document.createElement('a');
		a.href = urz.img.src;
		a.download = filename;
		a.click();
		a.remove();
		urz.konDanych = urz.poczLinii = 0;
		urz.dane.fill(0, 0, 32);
		urz.guzv.setAttribute ('class', 'vIO');
		zapalRejestry();
	}
 }
}

function fUuW() { // Oderwanie wydruku
 let urz = urzIO[9];
 if (urz.dane) {
	let dt = new Date();		dt.setTime( dt.valueOf() - dt.getTimezoneOffset() * 60000 );
	let d = dt.toISOString(),	//2021-06-22T20:17:44.795Z
	    f = 'ODRA_' + d.substr(0,4) + d.substr(5,2) + d.substr(8,2) + '_' + d.substr(11,2) + d.substr(14,2) + d.substr(17,2) + '.txt';
	let filename = prompt("Nazwa składowanego wydruku", f);
	if (filename !== null) {
		if (filename === '') filename = f;
		let b = new Blob([urz.dane], {type: 'text/plain'});
		let a = document.createElement('a');
		a.href = URL.createObjectURL(b);
		a.download = filename;
		a.click();
		URL.revokeObjectURL(a.href);
		a.remove();
		let o = urz.okno;
		o.textContent = urz.dane = '';
		o.style.height = (urz.preWysOkna = urz.wysOkna = fontHeight + scrollbarHeight) + 'px';
		urz.prePozDanych = 0;
		urz.guzv.setAttribute ('class', 'wIO');
	}
 }
}

function fUuP(u) { // Oderwanie tasiemki
 let urz = urzIO[u];
 if (urz.pozDanych) {
	let dt = new Date();		dt.setTime( dt.valueOf() - dt.getTimezoneOffset() * 60000 );
	let d = dt.toISOString(),	//2021-06-22T20:17:44.795Z
	    f = 'ODRA_' + d.substr(0,4) + d.substr(5,2) + d.substr(8,2) + '_' + d.substr(11,2) + d.substr(14,2) + d.substr(17,2) + '.pt' + urz.szer;
	let filename = prompt("Nazwa składowanej tasiemki", f);
	if (filename !== null) {
		if (filename === '') filename = f;
		let b = new Blob([urz.dane.slice(0, urz.pozDanych)], {type: 'application/octet-stream'});
		let a = document.createElement('a');
		a.href = URL.createObjectURL(b);
		a.download = filename;
		a.click();
		URL.revokeObjectURL(a.href);
		a.remove();
		urz.prePozDanych = urz.pozDanych = 0;
		let o = urz.okno;
		o.textContent = urz.obraz = '';
		o.style.height = (urz.wysOkna = fontHeight) + 'px';
		urz.guzv.setAttribute ('class', 'vIO');
	}
 }
}

function fDs(u) { // Start/Stop wejścia dalekopisu 11,10,1
 if (zasilB) {
	let urz = urzIO[u],
	    z = -1,
	    b = urz.ruch;
	switch (b) {
	 case 2: // czeka
		if (urz.pozDanych < urz.dane.length)	break;
	 case 1: // biega
		z = u;
		u = 11;
		break;
	 default:// zatrzymane
		if (urz.pozDanych < urz.dane.length) {
			z = urzIO[11].ruch ? 11 : (11 - u);
			b = urzIO[z].ruch;
		} else
			u = -1;
	}
	if (z >= 0) {
		let urzz = urzIO[z];
		if (z !== 1) TTY.kodyWej = 0;
		if (z ===11) urzz.dane = '';
		urzz.ruch = 0;
		urzz.lamp.setAttribute ('class','lIO lam0');
	}	
	if (u >= 0) {
		let urzu = urzIO[u];
		if (u !== 11) {
			let w = (u === 1 ? 7 /*szer+2*/ : 1),
			    p = urzu.pozDanych;
			if (u === 1) urzu.okno.scrollTop = (p-1) * pfontHeight;
			urzu.okno.setSelectionRange(p *= w, p + w);
		}
		urzu.ruch = 1;
		urzu.lamp.setAttribute ('class','lIO lam1');
		if (b === 2) /*czeka*/ setTimeout(petlaCPU);
	}
 }
}

function fTTK() { // wywołanie klawiatury
	let o = urzIO[11].okno;
	o.style.display = (TTY.widacKlaw = !TTY.widacKlaw) ? 'block' : '';
	if (TTY.widacKlaw) ustawKlawisze();
	o.focus();
}

function fk(k) { // klawisz klawiatury ekranowej
 let urz = urzIO[11],
     tty = TTY;
 if (k === 70) {// Zamknij
	urz.okno.style.display = '';
	tty.widacKlaw = false;
 } else if (urz.ruch === 2) {
	let kl = tty.kla,
	    t = -1;
	switch (k) {
	 case 64:// CapsLock
		if (tty.alfabet.length > 64) {
			kl[64].style.boxShadow = (tty.stanShC === 0x60) ? '' : klaWcisniety;
			if (tty.stanShC === 0x40) {
				tty.stanShC = 0x60;
				kl[66].style.boxShadow = kl[67].style.boxShadow = '';
			} else {
				for (let i=32, a=tty.stanShC&0x40; i--;) if (i !== 4) kl[i].textContent = tty.alfabet.charAt(a+i);
				tty.stanShC = 0x60 - tty.stanShC;
			}
			t = 0x40;
		}
		break;
	 case 66:// ShiftL
	 case 67:// ShiftR
		if (tty.alfabet.length > 64) {
			kl[66].style.boxShadow = kl[67].style.boxShadow = (tty.stanShC === 0x40) ? '' : klaWcisniety;
			if (tty.stanShC === 0x60) {
				tty.stanShC = 0x40;
				kl[64].style.boxShadow = '';
			} else {
				for (let i=32; i--;) if (i !== 4) kl[i].textContent = tty.alfabet.charAt(tty.stanShC+i);
				tty.stanShC = 0x40 - tty.stanShC;
			}
		}
		t = 0x40;
		break;
	 case 68:// AltL
	 case 69:// AltR
		if (tty.alfabet.length > 96) {
			kl[68].style.boxShadow = kl[69].style.boxShadow = tty.stanAlt ? '' : klaWcisniety;
			tty.stanAlt = 0x40 - tty.stanAlt;
			for (let i=32, a=tty.stanAlt+32; i--;) if (i !== 4) kl[i+32].textContent = tty.alfabet.charAt(a+i);
		}
		t = 0x40;
		break;
	 case 65:// NewLine
		urz.dane = '\u000D\u000A';
		urz.pozDanych = 0;
		t = 0x40;
		break;
	 default:{
		let c = [2, 31, 27, 0, 8 /*LF,LS,FS,NU,CR*/].indexOf(k);
		if (c >= 0) {
			if (c > 3) c = 0;
			t = tty.krosownia[tty.stanMon & 0x1F][c] & 0x20;
			if (t !== tty.trybKlaw) {
				for (let i=32, d=32-t; --i;) {
					if ([2, 4, 8, 27, 31 /*LF,SP,CR,FS,LS*/].indexOf(i) < 0) {
						kl[i+d].disabled = true;
						if (tty.trybKlaw !== 0x40) kl[i+t].disabled = false;
					}
				}
				tty.trybKlaw = t;
			}
		}
		if (tty.trybKlaw === 0x40) {
			if (((k < 32) && (tty.stanShC === 0x00)) || ((k >= 32) && tty.stanAlt)) k += 64;
			urz.dane = tty.alfabetU.charAt(k);
			urz.caps = (tty.stanShC === 0x60) ? 1 : 0;
			urz.pozDanych = 0;
		} else
			tty.kodyWej = k | 32;
		if (tty.stanShC === 0x40) {
			kl[66].style.boxShadow = kl[67].style.boxShadow = '';
			for (let i=32; i--;) if (i !== 4) kl[i].textContent = tty.alfabet.charAt(i+64);
			tty.stanShC = 0x00;
		}
		if (tty.stanAlt) {
			kl[68].style.boxShadow = kl[69].style.boxShadow = '';
			for (let i=32; i--;) if (i !== 4) kl[i+32].textContent = tty.alfabet.charAt(i+32);
			tty.stanAlt = 0x00;
		}
		}
	}
	if ((t === 0x40) && (tty.trybKlaw !== 0x40)) {
		for (let i=32, e=(tty.trybKlaw ? 0 : 32); i--;) kl[i+e].disabled = false;
		tty.trybKlaw = 0x40;
	}
	urz.ruch = 1;
	urz.lamp.setAttribute ('class','lIO lam1');
	setTimeout(petlaCPU);
 }
}
			
function ustawWymiary() { 
	let t = document.createElement("span"); 
	document.body.appendChild(t); 
	t.style.fontFamily = '"Courier New", "Lucida Console", monospace';
	t.style.fontSize = "12px"; 
	t.style.lineHeight = "100%";
	t.style.height = 'auto'; 
	t.style.width = 'auto'; 
	t.style.position = 'absolute'; 
	t.style.whiteSpace = 'no-wrap'; 
//	t.style.fontWeight = 'bold';
	t.textContent = 'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW';
	let fw = fontWidth50= Math.ceil(t.clientWidth), 
	    fh = fontHeight = Math.ceil(t.clientHeight);
	document.body.removeChild(t); 
	oknoCPU.style.width = fw + "px";
	oknoCPU.style.height= (13 * fh) + "px";
	oknoZegar.style.width = Math.ceil(0.44 * fw) + "px";
	let d = document.createElement('div');
	d.style.overflowX = d.style.overflowY = 'scroll';
	d.style.width = d.style.height = '50px';
	document.body.append(d);
	let sw = scrollbarWidth  = d.offsetWidth  - d.clientWidth  + 1,
	    sh = scrollbarHeight = d.offsetHeight - d.clientHeight + 1;
	d.remove();
	let	ow5 = (Math.ceil(0.12 * fw) + sw) + 'px',
		ow8 = (Math.ceil(0.18 * fw) + sw) + 'px',
		oh = fh + 'px';
	for (let u=8; u--;) {
		let urz = urzIO[u],
		    os = urz.okno.style;
		os.width = (urz.szer === 5 ? ow5 : ow8);
		os.height= oh;
		urz.wysOkna = fh;
	}
	urzIO[8].okno.style.width = (256 + sw) + 'px';
	urzIO[8].okno.style.height= oh;
	urzIO[9].okno.style.width = urzIO[10].okno.style.width = (Math.ceil(1.44 * fw) + sw) + 'px';
	urzIO[9].okno.style.height= urzIO[10].okno.style.height= (urzIO[9].wysOkna = urzIO[10].wysOkna = fh + sh) + 'px';
}
